package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-12-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AllocationByOrder implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单编号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 订单金额
   */
  @TableField("orderMoney")
  private BigDecimal orderMoney;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 合同签约方
   */
  @TableField("contractSignatureName")
  private String contractSignatureName;

  /**
   * 订单待核销金额
   */
  @TableField("orderWaitingWrittenOffMoney")
  private BigDecimal orderWaitingWrittenOffMoney;

  /**
   * 订单已开票金额
   */
  @TableField("orderInvoiceMoney")
  private BigDecimal orderInvoiceMoney;

  /**
   * 订单开票状态
   */
  @TableField("orderInvoiceStatus")
  private String orderInvoiceStatus;

  /**
   * 结算周期开始时间
   */
  @TableField("settlementPeriodStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementPeriodStartDate;

  /**
   * 结算周期结束时间
   */
  @TableField("settlementPeriodEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementPeriodEndDate;

  /**
   * 订单日期
   */
  @TableField("orderDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderDate;

  /**
   * 本次认领金额
   */
  @TableField("currentTakenMoney")
  private BigDecimal currentTakenMoney;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("orderMoney", orderMoney);
      map.put("productName", productName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("contractSignatureName", contractSignatureName);
      map.put("orderWaitingWrittenOffMoney", orderWaitingWrittenOffMoney);
      map.put("orderInvoiceMoney", orderInvoiceMoney);
      map.put("orderInvoiceStatus", orderInvoiceStatus);
      map.put("settlementPeriodStartDate", BocpGenUtils.toTimestamp(settlementPeriodStartDate));
      map.put("settlementPeriodEndDate", BocpGenUtils.toTimestamp(settlementPeriodEndDate));
      map.put("orderDate", BocpGenUtils.toTimestamp(orderDate));
      map.put("currentTakenMoney", currentTakenMoney);
      return map;
  }

  public static AllocationByOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AllocationByOrder entity = new AllocationByOrder();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderMoney")) {
      Object obj = map.get("orderMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignatureName")) {
      Object obj = map.get("contractSignatureName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractSignatureName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderWaitingWrittenOffMoney")) {
      Object obj = map.get("orderWaitingWrittenOffMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderWaitingWrittenOffMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderWaitingWrittenOffMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderWaitingWrittenOffMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderWaitingWrittenOffMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderWaitingWrittenOffMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceMoney")) {
      Object obj = map.get("orderInvoiceMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderInvoiceMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderInvoiceMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderInvoiceMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOrderInvoiceMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderInvoiceMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderInvoiceStatus")) {
      Object obj = map.get("orderInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementPeriodStartDate")) {
      Object obj = map.get("settlementPeriodStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementPeriodStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementPeriodStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementPeriodStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementPeriodStartDate(null);
      }
    }
    if(map.containsKey("settlementPeriodEndDate")) {
      Object obj = map.get("settlementPeriodEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementPeriodEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementPeriodEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementPeriodEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementPeriodEndDate(null);
      }
    }
    if(map.containsKey("orderDate")) {
      Object obj = map.get("orderDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOrderDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderDate(null);
      }
    }
    if(map.containsKey("currentTakenMoney")) {
      Object obj = map.get("currentTakenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
