package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 对账单明细
 * </p>
 *
 * @author ultraman
 * @since 2021-12-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconciliationDetailData implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 租户
   */
  @TableField("tenantName")
  private String tenantName;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 结算周期开始时间
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 结算周期结束时间
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 付费方式
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 应付金额
   */
  @TableField("payableAmount")
  private BigDecimal payableAmount;

  /**
   * 优惠金额
   */
  @TableField("discountMoney")
  private BigDecimal discountMoney;

  /**
   * 数量
   */
  private BigDecimal amount;

  /**
   * 结算对账子单号
   */
  @TableField("reconciliationDetailCode")
  private String reconciliationDetailCode;

  /**
   * 项目编号
   */
  @TableField("projectNo")
  private String projectNo;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 公司ID
   */
  @TableField("companyID")
  private String companyID;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * 单价
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 结算对账主单号
   */
  @TableField("reconciliationCode")
  private String reconciliationCode;

  /**
   * 结算单生成日期
   */
  @TableField("reconciliationCreateTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reconciliationCreateTime;

  /**
   * 产品Code
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 结算金额
   */
  @TableField("reconciliationSettleAccounts")
  private BigDecimal reconciliationSettleAccounts;

  /**
   * 一次性单位(系统)
   */
  @TableField("oneTimeUnit")
  private String oneTimeUnit;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 结算金额
   */
  @TableField("settlementAmount")
  private String settlementAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("tenantName", tenantName);
      map.put("productName", productName);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("chargeType", chargeType);
      map.put("payableAmount", payableAmount);
      map.put("discountMoney", discountMoney);
      map.put("amount", amount);
      map.put("reconciliationDetailCode", reconciliationDetailCode);
      map.put("projectNo", projectNo);
      map.put("taxNo", taxNo);
      map.put("companyName", companyName);
      map.put("companyID", companyID);
      map.put("billingType", billingType);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("reconciliationCode", reconciliationCode);
      map.put("reconciliationCreateTime", BocpGenUtils.toTimestamp(reconciliationCreateTime));
      map.put("productCode", productCode);
      map.put("reconciliationSettleAccounts", reconciliationSettleAccounts);
      map.put("oneTimeUnit", oneTimeUnit);
      map.put("chargeCycle", chargeCycle);
      map.put("settlementAmount", settlementAmount);
      return map;
  }

  public static ReconciliationDetailData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconciliationDetailData entity = new ReconciliationDetailData();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountMoney")) {
      Object obj = map.get("discountMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationDetailCode")) {
      Object obj = map.get("reconciliationDetailCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconciliationDetailCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyID")) {
      Object obj = map.get("companyID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationCode")) {
      Object obj = map.get("reconciliationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReconciliationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationCreateTime")) {
      Object obj = map.get("reconciliationCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReconciliationCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReconciliationCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReconciliationCreateTime(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reconciliationSettleAccounts")) {
      Object obj = map.get("reconciliationSettleAccounts");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReconciliationSettleAccounts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReconciliationSettleAccounts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReconciliationSettleAccounts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("oneTimeUnit")) {
      Object obj = map.get("oneTimeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOneTimeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmount")) {
      Object obj = map.get("settlementAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementAmount((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
