package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否
 * </p>
 *
 * @author ultraman
 * @since 2022-02-16
 */
public enum WhtherOrNot {

    FALSE("false", "否"),
    TRUE("true", "是");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WhtherOrNot(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WhtherOrNot fromCode(String code){
        switch(code) {
            case "false":
                return FALSE;
            case "true":
                return TRUE;
            default:
                return null;
        }
    }
}
