package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-02-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 计价单位
   */
  @TableField("pricingUnit")
  private String pricingUnit;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 版本
   */
  private Long version;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 合同ID
   */
  @TableField("contractId")
  private String contractId;

  /**
   * 关联合同ID
   */
  @TableField("relatedContractId")
  private String relatedContractId;

  /**
   * 订单创建日期
   */
  @TableField("generateDateStr")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generateDateStr;

  /**
   * 订单生效日期
   */
  @TableField("effectiveDateStr")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectiveDateStr;

  /**
   * 订单失效日期
   */
  @TableField("expiryDateStr")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expiryDateStr;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 购买产品的数量
   */
  @TableField("purchaseQuantity")
  private BigDecimal purchaseQuantity;

  /**
   * 订单总金额(含税)
   */
  @TableField("totalAmountStr")
  private String totalAmountStr;

  /**
   * 订单付款比例
   */
  @TableField("paymentPercent")
  private BigDecimal paymentPercent;

  /**
   * 付费类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 服务收费类型
   */
  @TableField("serviceType")
  private String serviceType;

  /**
   * 是否保证金
   */
  @TableField("isRetentionMoney")
  private Boolean isRetentionMoney;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 待核销金额
   */
  @TableField("waitingAmount")
  private String waitingAmount;

  /**
   * 已核销金额
   */
  @TableField("readyAmount")
  private String readyAmount;

  /**
   * 优惠金额（含税）
   */
  @TableField("discountAmountWithTax")
  private String discountAmountWithTax;

  /**
   * 应付金额（含税）
   */
  @TableField("payableAmountWithTax")
  private String payableAmountWithTax;

  /**
   * 实付金额（含税）
   */
  @TableField("receivableAmountWithTax")
  private String receivableAmountWithTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 单价（不含税）
   */
  @TableField("unitPriceWithoutTax")
  private String unitPriceWithoutTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("pricingUnit", pricingUnit);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("version", version);
      map.put("orderStatus", orderStatus);
      map.put("contractId", contractId);
      map.put("relatedContractId", relatedContractId);
      map.put("generateDateStr", BocpGenUtils.toTimestamp(generateDateStr));
      map.put("effectiveDateStr", BocpGenUtils.toTimestamp(effectiveDateStr));
      map.put("expiryDateStr", BocpGenUtils.toTimestamp(expiryDateStr));
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("purchaseQuantity", purchaseQuantity);
      map.put("totalAmountStr", totalAmountStr);
      map.put("paymentPercent", paymentPercent);
      map.put("paymentType", paymentType);
      map.put("serviceType", serviceType);
      map.put("isRetentionMoney", isRetentionMoney);
      map.put("paymentRequirement", paymentRequirement);
      map.put("waitingAmount", waitingAmount);
      map.put("readyAmount", readyAmount);
      map.put("discountAmountWithTax", discountAmountWithTax);
      map.put("payableAmountWithTax", payableAmountWithTax);
      map.put("receivableAmountWithTax", receivableAmountWithTax);
      map.put("taxRate", taxRate);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      return map;
  }

  public static OrderInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderInfo entity = new OrderInfo();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVersion((Long)obj);
        } else if(obj instanceof String) {
          entity.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generateDateStr")) {
      Object obj = map.get("generateDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGenerateDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGenerateDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGenerateDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGenerateDateStr(null);
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectiveDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEffectiveDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectiveDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectiveDateStr(null);
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpiryDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpiryDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setExpiryDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpiryDateStr(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmountStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWaitingAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReadyAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountAmountWithTax")) {
      Object obj = map.get("discountAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payableAmountWithTax")) {
      Object obj = map.get("payableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayableAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivableAmountWithTax")) {
      Object obj = map.get("receivableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceivableAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitPriceWithoutTax((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPricingUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVersion((Long)obj);
        } else if(obj instanceof String) {
          this.setVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relatedContractId")) {
      Object obj = map.get("relatedContractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelatedContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("generateDateStr")) {
      Object obj = map.get("generateDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGenerateDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGenerateDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setGenerateDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGenerateDateStr(null);
      }
    }
    if(map.containsKey("effectiveDateStr")) {
      Object obj = map.get("effectiveDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEffectiveDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEffectiveDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setEffectiveDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEffectiveDateStr(null);
      }
    }
    if(map.containsKey("expiryDateStr")) {
      Object obj = map.get("expiryDateStr");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpiryDateStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpiryDateStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setExpiryDateStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpiryDateStr(null);
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseQuantity")) {
      Object obj = map.get("purchaseQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchaseQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchaseQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchaseQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPurchaseQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaseQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmountStr")) {
      Object obj = map.get("totalAmountStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalAmountStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serviceType")) {
      Object obj = map.get("serviceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isRetentionMoney")) {
      Object obj = map.get("isRetentionMoney");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsRetentionMoney((Boolean)obj);
        } else if(obj instanceof String) {
          this.setIsRetentionMoney(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentRequirement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("waitingAmount")) {
      Object obj = map.get("waitingAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWaitingAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("readyAmount")) {
      Object obj = map.get("readyAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReadyAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountAmountWithTax")) {
      Object obj = map.get("discountAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payableAmountWithTax")) {
      Object obj = map.get("payableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayableAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivableAmountWithTax")) {
      Object obj = map.get("receivableAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivableAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitPriceWithoutTax((String)obj);
        }
      } else {
      }
    }
  }
}
