package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CapitalJournal implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("invoiceCode")
  private String invoiceCode;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("billNo")
  private String billNo;

  @TableField("projectCode")
  private String projectCode;

  @TableField("projectName")
  private String projectName;

  @TableField("productCode")
  private String productCode;

  @TableField("productName")
  private String productName;

  @TableField("productModel")
  private String productModel;

  @TableField("usePurchaserName")
  private String usePurchaserName;

  @TableField("usePurchaserTaxID")
  private String usePurchaserTaxID;

  @TableField("invoicePurchaserName")
  private String invoicePurchaserName;

  @TableField("invoicePurchaserTax")
  private String invoicePurchaserTax;

  @TableField("invoicePurchaserPhone")
  private String invoicePurchaserPhone;

  @TableField("invoicePurchaserAddr")
  private String invoicePurchaserAddr;

  @TableField("invoicePurchaserAccount")
  private String invoicePurchaserAccount;

  @TableField("invoicePurchaserBank")
  private String invoicePurchaserBank;

  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  @TableField("paybackMoney")
  private BigDecimal paybackMoney;

  @TableField("paymentAmount")
  private BigDecimal paymentAmount;

  @TableField("netPayment")
  private BigDecimal netPayment;

  @TableField("settlementAmountTax")
  private BigDecimal settlementAmountTax;

  @TableField("invoiceAmount")
  private BigDecimal invoiceAmount;

  @TableField("invoiceAmountTax")
  private BigDecimal invoiceAmountTax;

  @TableField("taxEd")
  private String taxEd;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("goodsName")
  private String goodsName;

  @TableField("settlementCondition")
  private String settlementCondition;

  @TableField("paymentBankAccount")
  private String paymentBankAccount;

  @TableField("paymentBankName")
  private String paymentBankName;

  @TableField("appointPaymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime appointPaymentDate;

  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  @TableField("billingType")
  private String billingType;

  @TableField("signTeam")
  private String signTeam;

  @TableField("paymentNature")
  private String paymentNature;

  @TableField("settlementStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementStartDate;

  @TableField("settlementEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementEndDate;

  @TableField("mappingStatus")
  private String mappingStatus;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("billNo", billNo);
      map.put("projectCode", projectCode);
      map.put("projectName", projectName);
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("productModel", productModel);
      map.put("usePurchaserName", usePurchaserName);
      map.put("usePurchaserTaxID", usePurchaserTaxID);
      map.put("invoicePurchaserName", invoicePurchaserName);
      map.put("invoicePurchaserTax", invoicePurchaserTax);
      map.put("invoicePurchaserPhone", invoicePurchaserPhone);
      map.put("invoicePurchaserAddr", invoicePurchaserAddr);
      map.put("invoicePurchaserAccount", invoicePurchaserAccount);
      map.put("invoicePurchaserBank", invoicePurchaserBank);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("paybackMoney", paybackMoney);
      map.put("paymentAmount", paymentAmount);
      map.put("netPayment", netPayment);
      map.put("settlementAmountTax", settlementAmountTax);
      map.put("invoiceAmount", invoiceAmount);
      map.put("invoiceAmountTax", invoiceAmountTax);
      map.put("taxEd", taxEd);
      map.put("taxRate", taxRate);
      map.put("taxAmount", taxAmount);
      map.put("goodsName", goodsName);
      map.put("settlementCondition", settlementCondition);
      map.put("paymentBankAccount", paymentBankAccount);
      map.put("paymentBankName", paymentBankName);
      map.put("appointPaymentDate", BocpGenUtils.toTimestamp(appointPaymentDate));
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("billingType", billingType);
      map.put("signTeam", signTeam);
      map.put("paymentNature", paymentNature);
      map.put("settlementStartDate", BocpGenUtils.toTimestamp(settlementStartDate));
      map.put("settlementEndDate", BocpGenUtils.toTimestamp(settlementEndDate));
      map.put("mappingStatus", mappingStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static CapitalJournal fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CapitalJournal entity = new CapitalJournal();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectCode")) {
      Object obj = map.get("projectCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productModel")) {
      Object obj = map.get("productModel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usePurchaserName")) {
      Object obj = map.get("usePurchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsePurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usePurchaserTaxID")) {
      Object obj = map.get("usePurchaserTaxID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsePurchaserTaxID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserName")) {
      Object obj = map.get("invoicePurchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserTax")) {
      Object obj = map.get("invoicePurchaserTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserPhone")) {
      Object obj = map.get("invoicePurchaserPhone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserAddr")) {
      Object obj = map.get("invoicePurchaserAddr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserAccount")) {
      Object obj = map.get("invoicePurchaserAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicePurchaserBank")) {
      Object obj = map.get("invoicePurchaserBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicePurchaserBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("paybackMoney")) {
      Object obj = map.get("paybackMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaybackMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaybackMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaybackMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaybackMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaybackMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentAmount")) {
      Object obj = map.get("paymentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("netPayment")) {
      Object obj = map.get("netPayment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setNetPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmountTax")) {
      Object obj = map.get("settlementAmountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSettlementAmountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountTax")) {
      Object obj = map.get("invoiceAmountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxEd")) {
      Object obj = map.get("taxEd");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxEd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsName")) {
      Object obj = map.get("goodsName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementCondition")) {
      Object obj = map.get("settlementCondition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBankAccount")) {
      Object obj = map.get("paymentBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBankName")) {
      Object obj = map.get("paymentBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appointPaymentDate")) {
      Object obj = map.get("appointPaymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppointPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAppointPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAppointPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAppointPaymentDate(null);
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNature")) {
      Object obj = map.get("paymentNature");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNature((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementStartDate")) {
      Object obj = map.get("settlementStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementStartDate(null);
      }
    }
    if(map.containsKey("settlementEndDate")) {
      Object obj = map.get("settlementEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettlementEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettlementEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementEndDate(null);
      }
    }
    if(map.containsKey("mappingStatus")) {
      Object obj = map.get("mappingStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMappingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
