package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Contract implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("contractNo")
  private String contractNo;

  @TableField("projectNo")
  private String projectNo;

  @TableField("projectName")
  private String projectName;

  @TableField("groupNo")
  private String groupNo;

  @TableField("signTeam")
  private String signTeam;

  @TableField("signatoryName")
  private String signatoryName;

  @TableField("periodPromise")
  private String periodPromise;

  @TableField("expenseBearer")
  private String expenseBearer;

  @TableField("paymentPeriod")
  private Long paymentPeriod;

  @TableField("paymentPeriodType")
  private String paymentPeriodType;

  @TableField("signDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signDate;

  @TableField("effectStartTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectStartTime;

  @TableField("effectEndTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectEndTime;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  private String kam;

  @TableField("signBuyerTel")
  private String signBuyerTel;

  @TableField("signBuyerEmail")
  private String signBuyerEmail;

  @TableField("signBuyerBankAccount")
  private String signBuyerBankAccount;

  @TableField("signBuyerBankName")
  private String signBuyerBankName;

  @TableField("signBuyerAddress")
  private String signBuyerAddress;

  @TableField("signBuyerTaxNo")
  private String signBuyerTaxNo;

  @TableField("signBuyerName")
  private String signBuyerName;

  @TableField("signTaxNoInvoiceType")
  private String signTaxNoInvoiceType;

  @TableField("receiverTel")
  private String receiverTel;

  @TableField("receiverPostcode")
  private String receiverPostcode;

  @TableField("receiverAddress")
  private String receiverAddress;

  @TableField("receiverName")
  private String receiverName;

  @TableField("contractRecordNo")
  private String contractRecordNo;

  @TableField("purchaseContractNo")
  private String purchaseContractNo;

  @TableField("receiptSignDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiptSignDate;

  @TableField("chargeStartCondition")
  private String chargeStartCondition;

  @TableField("createUser")
  private String createUser;

  @TableField("updateUser")
  private String updateUser;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("groupNo", groupNo);
      map.put("signTeam", signTeam);
      map.put("signatoryName", signatoryName);
      map.put("periodPromise", periodPromise);
      map.put("expenseBearer", expenseBearer);
      map.put("paymentPeriod", paymentPeriod);
      map.put("paymentPeriodType", paymentPeriodType);
      map.put("signDate", BocpGenUtils.toTimestamp(signDate));
      map.put("effectStartTime", BocpGenUtils.toTimestamp(effectStartTime));
      map.put("effectEndTime", BocpGenUtils.toTimestamp(effectEndTime));
      map.put("amountWithTax", amountWithTax);
      map.put("kam", kam);
      map.put("signBuyerTel", signBuyerTel);
      map.put("signBuyerEmail", signBuyerEmail);
      map.put("signBuyerBankAccount", signBuyerBankAccount);
      map.put("signBuyerBankName", signBuyerBankName);
      map.put("signBuyerAddress", signBuyerAddress);
      map.put("signBuyerTaxNo", signBuyerTaxNo);
      map.put("signBuyerName", signBuyerName);
      map.put("signTaxNoInvoiceType", signTaxNoInvoiceType);
      map.put("receiverTel", receiverTel);
      map.put("receiverPostcode", receiverPostcode);
      map.put("receiverAddress", receiverAddress);
      map.put("receiverName", receiverName);
      map.put("contractRecordNo", contractRecordNo);
      map.put("purchaseContractNo", purchaseContractNo);
      map.put("receiptSignDate", BocpGenUtils.toTimestamp(receiptSignDate));
      map.put("chargeStartCondition", chargeStartCondition);
      map.put("createUser", createUser);
      map.put("updateUser", updateUser);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Contract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Contract entity = new Contract();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groupNo")) {
      Object obj = map.get("groupNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGroupNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTeam")) {
      Object obj = map.get("signTeam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTeam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signatoryName")) {
      Object obj = map.get("signatoryName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignatoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("periodPromise")) {
      Object obj = map.get("periodPromise");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPeriodPromise((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseBearer")) {
      Object obj = map.get("expenseBearer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpenseBearer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriod")) {
      Object obj = map.get("paymentPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaymentPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaymentPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paymentPeriodType")) {
      Object obj = map.get("paymentPeriodType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentPeriodType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signDate")) {
      Object obj = map.get("signDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignDate(null);
      }
    }
    if(map.containsKey("effectStartTime")) {
      Object obj = map.get("effectStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectStartTime(null);
      }
    }
    if(map.containsKey("effectEndTime")) {
      Object obj = map.get("effectEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEffectEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectEndTime(null);
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("kam")) {
      Object obj = map.get("kam");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerTel")) {
      Object obj = map.get("signBuyerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerEmail")) {
      Object obj = map.get("signBuyerEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerBankAccount")) {
      Object obj = map.get("signBuyerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerBankName")) {
      Object obj = map.get("signBuyerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerAddress")) {
      Object obj = map.get("signBuyerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerTaxNo")) {
      Object obj = map.get("signBuyerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signBuyerName")) {
      Object obj = map.get("signBuyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signTaxNoInvoiceType")) {
      Object obj = map.get("signTaxNoInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignTaxNoInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverTel")) {
      Object obj = map.get("receiverTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverPostcode")) {
      Object obj = map.get("receiverPostcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverPostcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverAddress")) {
      Object obj = map.get("receiverAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverName")) {
      Object obj = map.get("receiverName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractRecordNo")) {
      Object obj = map.get("contractRecordNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractRecordNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseContractNo")) {
      Object obj = map.get("purchaseContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptSignDate")) {
      Object obj = map.get("receiptSignDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiptSignDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiptSignDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiptSignDate(null);
      }
    }
    if(map.containsKey("chargeStartCondition")) {
      Object obj = map.get("chargeStartCondition");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeStartCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
