package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-03-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IncomeItem implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 对账单编号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 订单号
   */
  @TableField("relatedOrderNos")
  private String relatedOrderNos;

  /**
   * 使用公司名称
   */
  @TableField("taxCompanyName")
  private String taxCompanyName;

  /**
   * 使用公司税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 性质
   */
  private String property;

  /**
   * 计价单位
   */
  @TableField("pricingUnit")
  private String pricingUnit;

  /**
   * 开始计费日期
   */
  @TableField("chargeStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeStartDate;

  /**
   * 结束计费日期
   */
  @TableField("chargeEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeEndDate;

  /**
   * 使用月份
   */
  @TableField("usingMonth")
  private Long usingMonth;

  /**
   * 会计期间
   */
  @TableField("accountingPeriod")
  private Long accountingPeriod;

  /**
   * 合同号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 当期收入金额（不含税）
   */
  @TableField("currentPeriodAmountWithoutTax")
  private BigDecimal currentPeriodAmountWithoutTax;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("relatedOrderNos", relatedOrderNos);
      map.put("taxCompanyName", taxCompanyName);
      map.put("taxNo", taxNo);
      map.put("property", property);
      map.put("pricingUnit", pricingUnit);
      map.put("chargeStartDate", BocpGenUtils.toTimestamp(chargeStartDate));
      map.put("chargeEndDate", BocpGenUtils.toTimestamp(chargeEndDate));
      map.put("usingMonth", usingMonth);
      map.put("accountingPeriod", accountingPeriod);
      map.put("contractNo", contractNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("quantity", quantity);
      map.put("currentPeriodAmountWithoutTax", currentPeriodAmountWithoutTax);
      return map;
  }

  public static IncomeItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IncomeItem entity = new IncomeItem();
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relatedOrderNos")) {
      Object obj = map.get("relatedOrderNos");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelatedOrderNos((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCompanyName")) {
      Object obj = map.get("taxCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("property")) {
      Object obj = map.get("property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingUnit")) {
      Object obj = map.get("pricingUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPricingUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeStartDate")) {
      Object obj = map.get("chargeStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeStartDate(null);
      }
    }
    if(map.containsKey("chargeEndDate")) {
      Object obj = map.get("chargeEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeEndDate(null);
      }
    }
    if(map.containsKey("usingMonth")) {
      Object obj = map.get("usingMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setUsingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUsingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accountingPeriod")) {
      Object obj = map.get("accountingPeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingPeriod(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountingPeriod(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentPeriodAmountWithoutTax")) {
      Object obj = map.get("currentPeriodAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentPeriodAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentPeriodAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentPeriodAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentPeriodAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentPeriodAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }
}
