package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 结算条件
 * </p>
 *
 * @author ultraman
 * @since 2021-08-26
 */
public enum SettlementCondition {

    _1("1", "签约后"),
    _2("2", "业务蓝图规划后"),
    _3("3", "验收后"),
    _4("4", "质保款"),
    _5("5", "上线报告"),
    _6("6", "测试报告");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SettlementCondition(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementCondition fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
