package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 性质
 * </p>
 *
 * @author ultraman
 * @since 2022-04-24
 */
public enum Property {

    ONE_TIME("oneTime", "一次性"),
    CONTINUITY("continuity", "持续性");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Property(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Property fromCode(String code){
        switch(code) {
            case "oneTime":
                return ONE_TIME;
            case "continuity":
                return CONTINUITY;
            default:
                return null;
        }
    }
}
