package com.xforceplus.financialsettlement.metadata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* <p>
    * 
    * </p>
*
* @author ultraman
* @since 2022-04-24
*/

public class EntityMeta {

    public interface ChargeMetaData {
        static Long id() {
            return 1414504703901081602L;
        }
        static String code() {
            return "chargeMetaData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGEDIMENSION = new TypedField<>(String.class, "chargeDimension");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGEITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> CHARGELABEL = new TypedField<>(String.class, "chargeLabel");
        TypedField<BigDecimal> CHARGEMONEYWITHOUTTAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> ACTUALUSAGE = new TypedField<>(BigDecimal.class, "actualUsage");
        TypedField<Long> USINGMONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> ISWARANTY = new TypedField<>(String.class, "isWaranty");
        TypedField<BigDecimal> LIMITAMOUNT = new TypedField<>(BigDecimal.class, "limitAmount");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> COMPANYID = new TypedField<>(String.class, "companyId");
        TypedField<String> RECONCILATIONCODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<LocalDateTime> SETTLEMENTSTARTTIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENTENDTIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACTID = new TypedField<>(String.class, "contractId");
        TypedField<String> CHARGEBIZDIMENSION = new TypedField<>(String.class, "chargeBizDimension");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<String> BILLCODE = new TypedField<>(String.class, "billCode");
        TypedField<String> PAYMENTTYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> HANDLESTATUS = new TypedField<>(String.class, "handleStatus");
    }

    public interface Costing {
        static Long id() {
            return 1415207897100840961L;
        }
        static String code() {
            return "costing";
        }
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> CHARGE_TYPE = new TypedField<>(String.class, "charge_type");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<BigDecimal> CHARGE_MONEY = new TypedField<>(BigDecimal.class, "charge_money");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrence_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeCode {
        static Long id() {
            return 1415208266803572738L;
        }
        static String code() {
            return "chargeCode";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<String> CUSTOMER_CODE = new TypedField<>(String.class, "customer_code");
        TypedField<String> CLASSIFICATION = new TypedField<>(String.class, "classification");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProjectBasicInfo {
        static Long id() {
            return 1415208663073026050L;
        }
        static String code() {
            return "projectBasicInfo";
        }
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> PROJECT_NAME = new TypedField<>(String.class, "project_name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> TENTANT_NAME = new TypedField<>(String.class, "tentant_name");
        TypedField<String> PRODUCT_MODEL = new TypedField<>(String.class, "product_model");
        TypedField<BigDecimal> COUNT = new TypedField<>(BigDecimal.class, "count");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProductAllocation {
        static Long id() {
            return 1415208799121907714L;
        }
        static String code() {
            return "productAllocation";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<LocalDateTime> TIME = new TypedField<>(LocalDateTime.class, "time");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface UnitPrice {
        static Long id() {
            return 1415208953767653377L;
        }
        static String code() {
            return "unitPrice";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> INPUT_WAY = new TypedField<>(String.class, "input_way");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface AllocationRuleDetails {
        static Long id() {
            return 1415209110972604418L;
        }
        static String code() {
            return "allocationRuleDetails";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<BigDecimal> ALLOCATION_PROPORTION = new TypedField<>(BigDecimal.class, "allocation_proportion");
        TypedField<BigDecimal> CONSUMPTION = new TypedField<>(BigDecimal.class, "consumption");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
    }

    public interface AllocationRule {
        static Long id() {
            return 1415211734738006018L;
        }
        static String code() {
            return "allocationRule";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> ALLOCATION_TYPE = new TypedField<>(String.class, "allocation_type");
        TypedField<LocalDateTime> START_TIME = new TypedField<>(LocalDateTime.class, "start_time");
        TypedField<LocalDateTime> END_TIME = new TypedField<>(LocalDateTime.class, "end_time");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeCodeMaintain {
        static Long id() {
            return 1415212005962674177L;
        }
        static String code() {
            return "chargeCodeMaintain";
        }
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> CHARGE_BELONG_CODE = new TypedField<>(String.class, "charge_belong_code");
        TypedField<String> CHARGE_BELONG = new TypedField<>(String.class, "charge_belong");
        TypedField<String> SOLUTION_TYPE = new TypedField<>(String.class, "solution_type");
        TypedField<String> PROFESSION = new TypedField<>(String.class, "profession");
        TypedField<String> ACTIVITY_TYPE = new TypedField<>(String.class, "activity_type");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> SALE_TEAM = new TypedField<>(String.class, "sale_team");
        TypedField<String> PROJECT_CODE = new TypedField<>(String.class, "project_code");
        TypedField<String> SOLUTION_PHASE = new TypedField<>(String.class, "solution_phase");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface InfoBI {
        static Long id() {
            return 1415212818932035585L;
        }
        static String code() {
            return "infoBI";
        }
        TypedField<String> TAX_NUMBER = new TypedField<>(String.class, "tax_number");
        TypedField<String> PRODUCT_NAME = new TypedField<>(String.class, "product_name");
        TypedField<String> MIDDLE_GROUND_CODE = new TypedField<>(String.class, "middle_ground_code");
        TypedField<BigDecimal> AMOUNT_USAGE = new TypedField<>(BigDecimal.class, "amount_usage");
        TypedField<String> MIDDLE_GROUND_NAME = new TypedField<>(String.class, "middle_ground_name");
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "product_code");
        TypedField<String> TENTANT = new TypedField<>(String.class, "tentant");
        TypedField<LocalDateTime> STARTING_TIME = new TypedField<>(LocalDateTime.class, "starting_time");
        TypedField<LocalDateTime> ENDING_TIME = new TypedField<>(LocalDateTime.class, "ending_time");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> TENTANT_CODE = new TypedField<>(String.class, "tentant_code");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CHARGE_CODE = new TypedField<>(String.class, "charge_code");
        TypedField<Long> YEAR = new TypedField<>(Long.class, "year");
        TypedField<Long> MONTH = new TypedField<>(Long.class, "month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ServiceCostDetails {
        static Long id() {
            return 1415214963842392066L;
        }
        static String code() {
            return "serviceCostDetails";
        }
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> COST_CODE = new TypedField<>(String.class, "cost_code");
        TypedField<String> PRODUCT_PHASE = new TypedField<>(String.class, "product_phase");
        TypedField<String> COST_TYPE = new TypedField<>(String.class, "cost_type");
        TypedField<String> COST_BELONG = new TypedField<>(String.class, "cost_belong");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "data_source");
        TypedField<LocalDateTime> OCCURENCY_TIME = new TypedField<>(LocalDateTime.class, "occurency_time");
        TypedField<String> DEPARTMENT_NAME = new TypedField<>(String.class, "department_name");
        TypedField<String> DEPARTMENT_CODE = new TypedField<>(String.class, "department_code");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> SUBMIT_STATUS = new TypedField<>(String.class, "submit_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> COST_NAME = new TypedField<>(String.class, "cost_name");
        TypedField<String> PARENT_CHARGECODE = new TypedField<>(String.class, "parent_chargecode");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ServiceCost {
        static Long id() {
            return 1415215356366331905L;
        }
        static String code() {
            return "serviceCost";
        }
        TypedField<String> SERVICE_TYPE = new TypedField<>(String.class, "service_type");
        TypedField<String> SERVICE_CODE = new TypedField<>(String.class, "service_code");
        TypedField<String> SERVICE_NAME = new TypedField<>(String.class, "service_name");
        TypedField<LocalDateTime> OCCRENCY_TIME = new TypedField<>(LocalDateTime.class, "occrency_time");
        TypedField<String> DIVIDE_CODE = new TypedField<>(String.class, "divide_code");
        TypedField<String> CURRENCY_STATUS = new TypedField<>(String.class, "currency_status");
        TypedField<BigDecimal> CUMULATIVE_COST = new TypedField<>(BigDecimal.class, "cumulative_cost");
        TypedField<BigDecimal> CURRENT_COST = new TypedField<>(BigDecimal.class, "current_cost");
        TypedField<BigDecimal> CUMULATIVE_OUTPUT = new TypedField<>(BigDecimal.class, "cumulative_output");
        TypedField<BigDecimal> CURRENT_OUTPUT = new TypedField<>(BigDecimal.class, "current_output");
        TypedField<Long> ACCOUNTING_YEAR = new TypedField<>(Long.class, "accounting_year");
        TypedField<Long> ACCOUNTING_MONTH = new TypedField<>(Long.class, "accounting_month");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> SRV_CODE = new TypedField<>(String.class, "srv_code");
        TypedField<String> SRV_NAME = new TypedField<>(String.class, "srv_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface Income {
        static Long id() {
            return 1415498206489735170L;
        }
        static String code() {
            return "income";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> USECOMPANYNAME = new TypedField<>(String.class, "useCompanyName");
        TypedField<String> USECOMPANYTAXNO = new TypedField<>(String.class, "useCompanytaxNo");
        TypedField<String> PRODUCT = new TypedField<>(String.class, "product");
        TypedField<String> MODELNO = new TypedField<>(String.class, "modelNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNIT = new TypedField<>(BigDecimal.class, "unit");
        TypedField<BigDecimal> RATIO = new TypedField<>(BigDecimal.class, "ratio");
        TypedField<Long> NUMBER = new TypedField<>(Long.class, "number");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<LocalDateTime> RECEIPTDATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> STARTCHARGEDATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> ENDCHARGEDATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> USEMONTH = new TypedField<>(Long.class, "useMonth");
        TypedField<Long> USEYEAR = new TypedField<>(Long.class, "useYear");
        TypedField<BigDecimal> CURINCOME = new TypedField<>(BigDecimal.class, "curIncome");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> CORRESPONDINGTENANTID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDINGTENANTCODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDINGTENANTNAME = new TypedField<>(String.class, "correspondingTenantName");
    }

    public interface SettlementData {
        static Long id() {
            return 1415502111091400706L;
        }
        static String code() {
            return "settlementData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STATEMENTCREATEDATE = new TypedField<>(LocalDateTime.class, "statementCreateDate");
        TypedField<String> INVOICECOMPANYNAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICECOMPANYTAX = new TypedField<>(String.class, "invoiceCompanyTax");
        TypedField<LocalDateTime> INVOICEDATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
        TypedField<BigDecimal> INVOICEAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICEAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANYTAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGEMETHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<LocalDateTime> ACCEPTANCEDATE = new TypedField<>(LocalDateTime.class, "acceptanceDate");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<BigDecimal> CHARGEMONEYWITHOUTTAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithoutTax");
        TypedField<BigDecimal> CHARGEMONEYWITHTAX = new TypedField<>(BigDecimal.class, "chargeMoneyWithTax");
        TypedField<LocalDateTime> RETURNDATE = new TypedField<>(LocalDateTime.class, "returnDate");
        TypedField<BigDecimal> RETURNMONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> PAYERCOMPANY = new TypedField<>(String.class, "payerCompany");
        TypedField<String> CURRENTSTATUS = new TypedField<>(String.class, "currentStatus");
        TypedField<String> CHARGECYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> CHARGEDAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<BigDecimal> CURRENTDISCOUNTMONEYWITHTAX = new TypedField<>(BigDecimal.class, "currentDiscountMoneyWithTax");
        TypedField<BigDecimal> DISCOUNTLATERMONEYWITHTAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithTax");
        TypedField<BigDecimal> DISCOUNTLATERMONEYWITHOUTTAX = new TypedField<>(BigDecimal.class, "discountLaterMoneyWithoutTax");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> ORDERGENERATEDATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RECEIPTSIGNDATESTR = new TypedField<>(String.class, "receiptSignDateStr");
    }

    public interface Contract {
        static Long id() {
            return 1415514648138260481L;
        }
        static String code() {
            return "contract";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PERIODPROMISE = new TypedField<>(String.class, "periodPromise");
        TypedField<Long> PAYMENTPERIOD = new TypedField<>(Long.class, "paymentPeriod");
        TypedField<String> PAYMENTPERIODTYPE = new TypedField<>(String.class, "paymentPeriodType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Boolean> CONTAINSRETENTIONMONEY = new TypedField<>(Boolean.class, "containsRetentionMoney");
        TypedField<String> CHARGECODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CONTRACTTYPE = new TypedField<>(String.class, "contractType");
        TypedField<BigDecimal> CONTRACTTOTALMONEY = new TypedField<>(BigDecimal.class, "contractTotalMoney");
        TypedField<String> BUSINESSUNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPALPERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> CHARGECONTRACTID = new TypedField<>(String.class, "chargeContractId");
        TypedField<String> SACHARGECODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> SACHARGECODENAME = new TypedField<>(String.class, "saChargeCodeName");
        TypedField<String> TOTALAMOUNTWITHTAX = new TypedField<>(String.class, "totalAmountWithTax");
        TypedField<String> RELATEDCONTRACTNO = new TypedField<>(String.class, "relatedContractNo");
        TypedField<String> SIGNTEAMCODE = new TypedField<>(String.class, "signTeamCode");
        TypedField<String> SIGNTEAMNAME = new TypedField<>(String.class, "signTeamName");
        TypedField<String> CUSTOMERSIGNATORYTAXNOS = new TypedField<>(String.class, "customerSignatoryTaxNos");
        TypedField<String> CUSTOMERSIGNATORYNAME = new TypedField<>(String.class, "customerSignatoryName");
        TypedField<String> EXPENSEBEARER = new TypedField<>(String.class, "expenseBearer");
        TypedField<String> BUSINESSUNITDEPTCODE = new TypedField<>(String.class, "businessUnitDeptCode");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> KAMCODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> KAMNAME = new TypedField<>(String.class, "kamName");
        TypedField<String> REGIONCODE = new TypedField<>(String.class, "regionCode");
        TypedField<String> REGIONNAME = new TypedField<>(String.class, "regionName");
        TypedField<String> OURSIGNATORYNAME = new TypedField<>(String.class, "ourSignatoryName");
        TypedField<String> OURSIGNATORYTAXNO = new TypedField<>(String.class, "ourSignatoryTaxNo");
        TypedField<String> CHARGECYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> ATTACHMENTURL = new TypedField<>(String.class, "attachmentUrl");
        TypedField<String> SIGNDATESTR = new TypedField<>(String.class, "signDateStr");
        TypedField<String> EXPIRYDATESTR = new TypedField<>(String.class, "expiryDateStr");
        TypedField<String> RECEIPTSIGNDATESTR = new TypedField<>(String.class, "receiptSignDateStr");
        TypedField<String> EFFECTIVEDATESTR = new TypedField<>(String.class, "effectiveDateStr");
        TypedField<String> CONTRACTSTATUS = new TypedField<>(String.class, "contractStatus");
        TypedField<Long> CONTRACTVERSION = new TypedField<>(Long.class, "contractVersion");
        TypedField<String> SUPPLEMENTARYAGREEMENTTYPES = new TypedField<>(String.class, "supplementaryAgreementTypes");
        TypedField<LocalDateTime> RECEIPTSIGNDATE = new TypedField<>(LocalDateTime.class, "receiptSignDate");
        TypedField<String> SUPPLEMENTARYAGREEMENTTYPESDESC = new TypedField<>(String.class, "supplementaryAgreementTypesDesc");
        TypedField<String> MANDATORYRENEWAL = new TypedField<>(String.class, "mandatoryRenewal");
    }

    public interface Project {
        static Long id() {
            return 1415517014084415490L;
        }
        static String code() {
            return "project";
        }
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> SALEDIRECTOREMAIL = new TypedField<>(String.class, "saleDirectorEmail");
        TypedField<String> SALEDIRECTOR = new TypedField<>(String.class, "saleDirector");
        TypedField<String> EMAIL = new TypedField<>(String.class, "email");
        TypedField<String> SALEPRINCIPAL = new TypedField<>(String.class, "salePrincipal");
        TypedField<String> SIGNTEAM = new TypedField<>(String.class, "signTeam");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ProductFunction {
        static Long id() {
            return 1415519149595336706L;
        }
        static String code() {
            return "productFunction";
        }
        TypedField<String> PRODUCTNO = new TypedField<>(String.class, "productNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTTYPE = new TypedField<>(String.class, "productType");
        TypedField<String> FUNCTIONTYPE = new TypedField<>(String.class, "functionType");
        TypedField<String> FUNTIONDESC = new TypedField<>(String.class, "funtionDesc");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> PRODUCTSRVNAME = new TypedField<>(String.class, "productSrvName");
        TypedField<String> TAXED = new TypedField<>(String.class, "taxEd");
        TypedField<String> INVOICEUNIT = new TypedField<>(String.class, "invoiceUnit");
        TypedField<String> USEINVOICETYPE = new TypedField<>(String.class, "useInvoiceType");
        TypedField<LocalDateTime> SRVSTARTDATE = new TypedField<>(LocalDateTime.class, "srvStartDate");
        TypedField<LocalDateTime> SRVENDDATE = new TypedField<>(LocalDateTime.class, "srvEndDate");
        TypedField<String> CREATEUSER = new TypedField<>(String.class, "createUser");
        TypedField<String> UPDATEUSER = new TypedField<>(String.class, "updateUser");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface IncomeMainMsg {
        static Long id() {
            return 1415957144165621761L;
        }
        static String code() {
            return "incomeMainMsg";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> STARTCHARGETIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOPCHARGETIME = new TypedField<>(LocalDateTime.class, "stopChargeTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> CHARGEITEM = new TypedField<>(String.class, "chargeItem");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANYTAX = new TypedField<>(String.class, "companyTax");
        TypedField<BigDecimal> TOTALMONEYTAX = new TypedField<>(BigDecimal.class, "totalMoneyTax");
        TypedField<BigDecimal> TOTALMONEYWITHOUTTAX = new TypedField<>(BigDecimal.class, "totalMoneyWithoutTax");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<LocalDateTime> SETTLEMENTSTARTTIME = new TypedField<>(LocalDateTime.class, "settlementStartTime");
        TypedField<LocalDateTime> SETTLEMENTENDTIME = new TypedField<>(LocalDateTime.class, "settlementEndTime");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> CORRESPONDINGTENANTID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDINGTENANTCODE = new TypedField<>(String.class, "correspondingTenantCode");
        TypedField<String> CORRESPONDINGTENANTNAME = new TypedField<>(String.class, "correspondingTenantName");
        TypedField<String> INCOMESTATUS = new TypedField<>(String.class, "incomeStatus");
    }

    public interface ChargeJob {
        static Long id() {
            return 1416945394439102465L;
        }
        static String code() {
            return "chargeJob";
        }
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> INCOMEMAINMSGID = new TypedField<>(String.class, "incomeMainMsgId");
        TypedField<String> JOBTYPE = new TypedField<>(String.class, "jobType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELFID = new TypedField<>(String.class, "selfId");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHERRECEIVED = new TypedField<>(String.class, "whetherReceived");
        TypedField<String> WHETHERVALIDATE = new TypedField<>(String.class, "whetherValidate");
    }

    public interface IncomeDetail {
        static Long id() {
            return 1422827562209681410L;
        }
        static String code() {
            return "incomeDetail";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<LocalDateTime> STARTCHARGEDATE = new TypedField<>(LocalDateTime.class, "startChargeDate");
        TypedField<LocalDateTime> ENDCHARGEDATE = new TypedField<>(LocalDateTime.class, "endChargeDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANYTAX = new TypedField<>(String.class, "companyTax");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> CURRENTINCOMEWITHOUTTAX = new TypedField<>(BigDecimal.class, "currentIncomeWithoutTax");
        TypedField<String> ACCEPTANCEDATE = new TypedField<>(String.class, "acceptanceDate");
        TypedField<String> ACCOUNTINGTIME = new TypedField<>(String.class, "accountingTime");
        TypedField<String> CHARGEMETHOD = new TypedField<>(String.class, "chargeMethod");
        TypedField<String> USINGMONTH = new TypedField<>(String.class, "usingMonth");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESSUNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPALPERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGIONID = new TypedField<>(String.class, "regionId");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RELATEDORDERNOS = new TypedField<>(String.class, "relatedOrderNos");
    }

    public interface InvoiceData {
        static Long id() {
            return 1422867883811573762L;
        }
        static String code() {
            return "invoiceData";
        }
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGINALINVOICECODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINALINVOICENO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> SELLERTAXNAME = new TypedField<>(String.class, "sellerTaxName");
        TypedField<String> SELLERTAXNO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> TAXAMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> EFFECTIVESTATUS = new TypedField<>(String.class, "effectiveStatus");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> BUYERNAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYERTAXNO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> MATCHSTATUS = new TypedField<>(String.class, "matchStatus");
        TypedField<BigDecimal> AMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> AMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> INVOICEDATE = new TypedField<>(String.class, "invoiceDate");
        TypedField<BigDecimal> AMOUTWITHTAXUNMATCHED = new TypedField<>(BigDecimal.class, "amoutWithTaxUnMatched");
        TypedField<BigDecimal> PAYMENTFLOW = new TypedField<>(BigDecimal.class, "paymentFlow");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> REDSTATUS = new TypedField<>(Long.class, "redStatus");
        TypedField<String> BILLTYPE = new TypedField<>(String.class, "billType");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> CUSTOMERNO = new TypedField<>(String.class, "customerNo");
        TypedField<String> BUSINESSBILLTYPE = new TypedField<>(String.class, "businessBillType");
        TypedField<LocalDateTime> REDTIME = new TypedField<>(LocalDateTime.class, "redTime");
        TypedField<String> REDFLAG = new TypedField<>(String.class, "redFlag");
        TypedField<String> INVOICECOLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<String> INVOICETYPE = new TypedField<>(String.class, "invoiceType");
    }

    public interface JobList {
        static Long id() {
            return 1425736007619231745L;
        }
        static String code() {
            return "jobList";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<String> WHETHEREFFECTIVE = new TypedField<>(String.class, "whetherEffective");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ReconciliationDetailData {
        static Long id() {
            return 1428252466707075073L;
        }
        static String code() {
            return "reconciliationDetailData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> PAYABLEAMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<BigDecimal> DISCOUNTMONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> RECONCILIATIONDETAILCODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANYID = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECONCILIATIONCODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> RECONCILIATIONCREATETIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> RECONCILIATIONSETTLEACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> ONETIMEUNIT = new TypedField<>(String.class, "oneTimeUnit");
        TypedField<String> CHARGECYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<String> SETTLEMENTAMOUNT = new TypedField<>(String.class, "settlementAmount");
    }

    public interface ReconciliationAndInvoiceRelation {
        static Long id() {
            return 1428562157585108994L;
        }
        static String code() {
            return "reconciliationAndInvoiceRelation";
        }
        TypedField<String> RECONCILATIONCODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ReconciliationData {
        static Long id() {
            return 1429648136449986561L;
        }
        static String code() {
            return "reconciliationData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILATIONCODE = new TypedField<>(String.class, "reconcilationCode");
        TypedField<String> RECONCILATIONSTATUS = new TypedField<>(String.class, "reconcilationStatus");
        TypedField<BigDecimal> ACTUALMONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILATIONCREATETIME = new TypedField<>(LocalDateTime.class, "reconcilationCreateTime");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> DISCOUNTMONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<BigDecimal> PAYABLEAMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PAYMENTSTATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> SETTLEMENTAMOUNT = new TypedField<>(String.class, "settlementAmount");
        TypedField<String> DISCOUNTAMOUNT = new TypedField<>(String.class, "discountAmount");
    }

    public interface SettlementMainData {
        static Long id() {
            return 1432542303681417217L;
        }
        static String code() {
            return "settlementMainData";
        }
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGEREQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<BigDecimal> SETTLEDMONEYWITHTAX = new TypedField<>(BigDecimal.class, "settledMoneyWithTax");
        TypedField<BigDecimal> WAITINGSETTLEMONEYWITHTAX = new TypedField<>(BigDecimal.class, "waitingSettleMoneyWithTax");
        TypedField<BigDecimal> INVOICEDMONEYWITHTAX = new TypedField<>(BigDecimal.class, "invoicedMoneyWithTax");
        TypedField<BigDecimal> RETURNEDMONEY = new TypedField<>(BigDecimal.class, "returnedMoney");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> STATEMENTNO = new TypedField<>(String.class, "statementNo");
        TypedField<String> CUSTOMER = new TypedField<>(String.class, "customer");
        TypedField<String> BUSINESSUNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPALPERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<Long> TENANTGROUPID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<BigDecimal> ORDERTOTALMONEYWITHTAX = new TypedField<>(BigDecimal.class, "orderTotalMoneyWithTax");
        TypedField<String> REGION = new TypedField<>(String.class, "region");
        TypedField<String> REGIONID = new TypedField<>(String.class, "regionId");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
    }

    public interface PayWater {
        static Long id() {
            return 1433255154737909761L;
        }
        static String code() {
            return "payWater";
        }
        TypedField<LocalDateTime> TRADETIME = new TypedField<>(LocalDateTime.class, "tradeTime");
        TypedField<BigDecimal> DEBITMONEYAMOUNT = new TypedField<>(BigDecimal.class, "debitMoneyAmount");
        TypedField<BigDecimal> CREDITMONEYAMOUNT = new TypedField<>(BigDecimal.class, "creditMoneyAmount");
        TypedField<String> BANKNAME = new TypedField<>(String.class, "bankName");
        TypedField<String> BANKACCOUNT = new TypedField<>(String.class, "bankAccount");
        TypedField<String> OPENACCOUNTINSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CURRENCY = new TypedField<>(String.class, "currency");
        TypedField<String> CUSTOMERNAME = new TypedField<>(String.class, "customerName");
        TypedField<LocalDateTime> ACCOUNTINGDATE = new TypedField<>(LocalDateTime.class, "accountingDate");
        TypedField<String> ABSTRACTION = new TypedField<>(String.class, "abstraction");
        TypedField<String> TRADEBUSINESSCODE = new TypedField<>(String.class, "tradeBusinessCode");
        TypedField<BigDecimal> BALANCE = new TypedField<>(BigDecimal.class, "balance");
        TypedField<String> CUSTOMERACCOUNT = new TypedField<>(String.class, "customerAccount");
        TypedField<String> ENTERPRISESERIALNUMBER = new TypedField<>(String.class, "enterpriseSerialNumber");
        TypedField<String> DOCUMENTCATEGORY = new TypedField<>(String.class, "documentCategory");
        TypedField<String> DOCUMENTNO = new TypedField<>(String.class, "documentNo");
    }

    public interface StatisticBusinessUsage {
        static Long id() {
            return 1434914546386120706L;
        }
        static String code() {
            return "statisticBusinessUsage";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> RECONCILIATIONCODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> SETTLEMENTCYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> BUSINESSDIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> BUSINESSTIME = new TypedField<>(String.class, "businessTime");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
    }

    public interface SettlementDetailAndInvoiceRelation {
        static Long id() {
            return 1437620316654374914L;
        }
        static String code() {
            return "settlementDetailAndInvoiceRelation";
        }
        TypedField<String> SETTLEMENTDETAILCODE = new TypedField<>(String.class, "settlementDetailCode");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
    }

    public interface RecordTable {
        static Long id() {
            return 1451184261675716610L;
        }
        static String code() {
            return "recordTable";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> RECONCILIATIONCODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<BigDecimal> RECONCILIATIONSETTLEACCOUNTS = new TypedField<>(BigDecimal.class, "reconciliationSettleAccounts");
        TypedField<String> RECONCILIATIONSTATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<String> WARRANTY = new TypedField<>(String.class, "warranty");
        TypedField<String> INCOMETYPE = new TypedField<>(String.class, "incomeType");
        TypedField<BigDecimal> ACTUALMONEY = new TypedField<>(BigDecimal.class, "actualMoney");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<LocalDateTime> RECONCILIATIONCREATETIME = new TypedField<>(LocalDateTime.class, "reconciliationCreateTime");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> DISCOUNTMONEY = new TypedField<>(BigDecimal.class, "discountMoney");
        TypedField<BigDecimal> PAYABLEAMOUNT = new TypedField<>(BigDecimal.class, "payableAmount");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> SETTLEMENTCYCLE = new TypedField<>(String.class, "settlementCycle");
        TypedField<String> WHETHERVALIDATION = new TypedField<>(String.class, "whetherValidation");
        TypedField<String> PAYMENTSTATUS = new TypedField<>(String.class, "paymentStatus");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RECONCILIATIONDETAILCODE = new TypedField<>(String.class, "reconciliationDetailCode");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANYID = new TypedField<>(String.class, "companyID");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESSDIMENSION = new TypedField<>(String.class, "businessDimension");
        TypedField<BigDecimal> USAGE = new TypedField<>(BigDecimal.class, "usage");
        TypedField<String> COMPRESS = new TypedField<>(String.class, "compress");
        TypedField<String> RECORDTYPE = new TypedField<>(String.class, "recordType");
    }

    public interface ContractDetail {
        static Long id() {
            return 1455020711739621378L;
        }
        static String code() {
            return "contractDetail";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<BigDecimal> AMOUNT = new TypedField<>(BigDecimal.class, "amount");
        TypedField<BigDecimal> UNITPRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<String> CHARGEREQUIREMENT = new TypedField<>(String.class, "chargeRequirement");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> VALIDATION = new TypedField<>(String.class, "validation");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNITPRICEWITHOUTTAX = new TypedField<>(String.class, "unitPriceWithoutTax");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<BigDecimal> PAYMENTPERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> CONTAINSRETENTIONMONEY = new TypedField<>(String.class, "containsRetentionMoney");
        TypedField<String> RECEIPTSIGNDATESTR = new TypedField<>(String.class, "receiptSignDateStr");
        TypedField<String> FIRSTPAYREQUIREMENTORNOT = new TypedField<>(String.class, "firstPayRequirementOrNot");
    }

    public interface TaxNoList {
        static Long id() {
            return 1455075594576560130L;
        }
        static String code() {
            return "taxNoList";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> STARTCHARGETIME = new TypedField<>(LocalDateTime.class, "startChargeTime");
        TypedField<LocalDateTime> STOPTIME = new TypedField<>(LocalDateTime.class, "stopTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAXNOSTATUS = new TypedField<>(String.class, "taxNoStatus");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<LocalDateTime> OPENTIME = new TypedField<>(LocalDateTime.class, "openTime");
    }

    public interface ContractRawData {
        static Long id() {
            return 1455449612420874242L;
        }
        static String code() {
            return "contractRawData";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNO = new TypedField<>(String.class, "projectNo");
        TypedField<Long> TENANTGROUPID = new TypedField<>(Long.class, "tenantGroupId");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> JSONSTR = new TypedField<>(String.class, "jsonStr");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHARGECONTRACTID = new TypedField<>(String.class, "chargeContractId");
    }

    public interface ChargeCodePool {
        static Long id() {
            return 1455811807088549889L;
        }
        static String code() {
            return "chargeCodePool";
        }
        TypedField<String> CCCODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CCNAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CCTYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> RELATIONCODES = new TypedField<>(String.class, "relationCodes");
        TypedField<String> DISTRICT = new TypedField<>(String.class, "district");
        TypedField<String> BIZUNIT = new TypedField<>(String.class, "bizUnit");
        TypedField<String> CCSTATUS = new TypedField<>(String.class, "ccStatus");
        TypedField<String> EXTENSIONTAG = new TypedField<>(String.class, "extensionTag");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> KAM = new TypedField<>(String.class, "kam");
        TypedField<String> OWNERCODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNERNAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> PRIMARYLEADERCODE = new TypedField<>(String.class, "primaryLeaderCode");
        TypedField<String> PRIMARYLEADERNAME = new TypedField<>(String.class, "primaryLeaderName");
        TypedField<String> CCTYPECODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> DISTRICTCODE = new TypedField<>(String.class, "districtCode");
        TypedField<String> BIZUNITCODE = new TypedField<>(String.class, "bizUnitCode");
        TypedField<String> KAMCODE = new TypedField<>(String.class, "kamCode");
        TypedField<String> LEVELONEDEPARTMENTCODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> LEVELONEDEPARTMENTNAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> REQUESTID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSHTIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CCCREATEUSERID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CCCREATEUSERNAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CCUPDATEUSERID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CCUPDATEUSERNAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<LocalDateTime> INSERTTIME = new TypedField<>(LocalDateTime.class, "insertTime");
    }

    public interface ChargeGivenRelation {
        static Long id() {
            return 1458801856491102209L;
        }
        static String code() {
            return "chargeGivenRelation";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> RECONCILIATIONCODE = new TypedField<>(String.class, "reconciliationCode");
        TypedField<LocalDateTime> TAXSTARTDATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> SETTLEMENTSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementStartDate");
        TypedField<LocalDateTime> SETTLEMENTENDDATE = new TypedField<>(LocalDateTime.class, "settlementEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TAXNOCOMPANYNAME = new TypedField<>(String.class, "taxNoCompanyName");
        TypedField<Long> CORRESPONDINGTENANTID = new TypedField<>(Long.class, "correspondingTenantId");
        TypedField<String> CORRESPONDINGTENANTNAME = new TypedField<>(String.class, "correspondingTenantName");
    }

    public interface AuthorizedMembers {
        static Long id() {
            return 1460896585479196673L;
        }
        static String code() {
            return "authorizedMembers";
        }
        TypedField<String> AUTHORIZEDMEMBERCODE = new TypedField<>(String.class, "authorizedMemberCode");
        TypedField<String> AUTHORIZEDMEMBERNAME = new TypedField<>(String.class, "authorizedMemberName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACTIVE = new TypedField<>(String.class, "active");
        TypedField<LocalDateTime> INACTIVETIME = new TypedField<>(LocalDateTime.class, "inactiveTime");
    }

    public interface InvoiceRawData {
        static Long id() {
            return 1460936664507584513L;
        }
        static String code() {
            return "invoiceRawData";
        }
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> ORIGININVOICECODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGININVOICENO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> SELLERTAXNO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLERNAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PURCHASERTAXNO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASERNAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PAPERDRAWDATE = new TypedField<>(String.class, "paperDrawDate");
        TypedField<String> AMOUNTWITHTAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNTWITHOUTTAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAXAMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> INVOICETYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<LocalDateTime> DEPOSETIME = new TypedField<>(LocalDateTime.class, "deposeTime");
        TypedField<String> SALESBILLNO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RAWJSON = new TypedField<>(String.class, "rawJson");
    }

    public interface ReceivedPaymentsNotTaken {
        static Long id() {
            return 1461010346936832002L;
        }
        static String code() {
            return "receivedPaymentsNotTaken";
        }
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNEDTIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURNMONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMERNAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKENSTATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> WAITINGTAKENMONEY = new TypedField<>(BigDecimal.class, "waitingTakenMoney");
        TypedField<BigDecimal> TAKENMONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMERBANKNO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPENACCOUNTINSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CNY = new TypedField<>(String.class, "cny");
    }

    public interface ReceivedPaymentsNoNeed {
        static Long id() {
            return 1461010672058306561L;
        }
        static String code() {
            return "receivedPaymentsNoNeed";
        }
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNEDTIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURNMONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMERNAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKENSTATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<String> CUSTOMERBANKNO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPENACCOUNTINSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ReceivedPaymentsTaken {
        static Long id() {
            return 1461010979454652417L;
        }
        static String code() {
            return "receivedPaymentsTaken";
        }
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
        TypedField<LocalDateTime> RETURNEDTIME = new TypedField<>(LocalDateTime.class, "returnedTime");
        TypedField<BigDecimal> RETURNMONEY = new TypedField<>(BigDecimal.class, "returnMoney");
        TypedField<String> CUSTOMERNAME = new TypedField<>(String.class, "customerName");
        TypedField<String> TAKENSTATUS = new TypedField<>(String.class, "takenStatus");
        TypedField<BigDecimal> TAKENMONEY = new TypedField<>(BigDecimal.class, "takenMoney");
        TypedField<String> CUSTOMERBANKNO = new TypedField<>(String.class, "customerBankNo");
        TypedField<String> OPENACCOUNTINSTITUTIONS = new TypedField<>(String.class, "openAccountInstitutions");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CONTRACTSIGNATURENAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ACCOUNTNAME = new TypedField<>(String.class, "accountName");
        TypedField<String> SEARCHTYPE = new TypedField<>(String.class, "searchType");
    }

    public interface AllocationByOrder {
        static Long id() {
            return 1461023981952241666L;
        }
        static String code() {
            return "allocationByOrder";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDERMONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACTSIGNATURENAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDERWAITINGWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<BigDecimal> ORDERINVOICEMONEY = new TypedField<>(BigDecimal.class, "orderInvoiceMoney");
        TypedField<String> ORDERINVOICESTATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENTPERIODSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENTPERIODENDDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDERDATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<BigDecimal> CURRENTTAKENMONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
    }

    public interface AllocationByInvoice {
        static Long id() {
            return 1461157480399048706L;
        }
        static String code() {
            return "allocationByInvoice";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDERMONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACTSIGNATURENAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDERWAITINGWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDERINVOICESTATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENTPERIODSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENTPERIODENDDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENTTAKENMONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICECOMPANYNAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<BigDecimal> INVOICEMONEY = new TypedField<>(BigDecimal.class, "invoiceMoney");
        TypedField<BigDecimal> INVOICEWAITINGWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "invoiceWaitingWrittenOffMoney");
        TypedField<BigDecimal> INVOICEWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "invoiceWrittenOffMoney");
        TypedField<LocalDateTime> INVOICEDATE = new TypedField<>(LocalDateTime.class, "invoiceDate");
    }

    public interface AllocationByTaxNo {
        static Long id() {
            return 1461158165773488129L;
        }
        static String code() {
            return "allocationByTaxNo";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<BigDecimal> ORDERMONEY = new TypedField<>(BigDecimal.class, "orderMoney");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACTSIGNATURENAME = new TypedField<>(String.class, "contractSignatureName");
        TypedField<BigDecimal> ORDERWAITINGWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "orderWaitingWrittenOffMoney");
        TypedField<String> ORDERINVOICESTATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> SETTLEMENTPERIODSTARTDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodStartDate");
        TypedField<LocalDateTime> SETTLEMENTPERIODENDDATE = new TypedField<>(LocalDateTime.class, "settlementPeriodEndDate");
        TypedField<LocalDateTime> ORDERDATE = new TypedField<>(LocalDateTime.class, "orderDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> CURRENTTAKENMONEY = new TypedField<>(BigDecimal.class, "currentTakenMoney");
        TypedField<String> USINGCOMPANYNAME = new TypedField<>(String.class, "usingCompanyName");
        TypedField<BigDecimal> USINGPAYABLEMONEY = new TypedField<>(BigDecimal.class, "usingPayableMoney");
        TypedField<BigDecimal> USINGWRITTENOFFMONEY = new TypedField<>(BigDecimal.class, "usingWrittenOffMoney");
        TypedField<String> USINGTAXNO = new TypedField<>(String.class, "usingTaxNo");
        TypedField<BigDecimal> USINGTAKENOFFMONEY = new TypedField<>(BigDecimal.class, "usingTakenOffMoney");
    }

    public interface NoNeedList {
        static Long id() {
            return 1461263582046392321L;
        }
        static String code() {
            return "noNeedList";
        }
        TypedField<String> CUSTOMERNAME = new TypedField<>(String.class, "customerName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface CapitalFlowOperationRecord {
        static Long id() {
            return 1464077964732080130L;
        }
        static String code() {
            return "capitalFlowOperationRecord";
        }
        TypedField<LocalDateTime> OPERATIONTIME = new TypedField<>(LocalDateTime.class, "operationTime");
        TypedField<String> OPERATIONPERSON = new TypedField<>(String.class, "operationPerson");
        TypedField<String> OPERATIONCONTENT = new TypedField<>(String.class, "operationContent");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
    }

    public interface Test {
        static Long id() {
            return 1467688303306440706L;
        }
        static String code() {
            return "test";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> AGE = new TypedField<>(Long.class, "age");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> RETENTIONMONEY = new TypedField<>(String.class, "retentionMoney");
        TypedField<String> NEWFIELD = new TypedField<>(String.class, "newField");
        TypedField<String> TEST = new TypedField<>(String.class, "test");
    }

    public interface SettleStaticsOrderRel {
        static Long id() {
            return 1469139798002339842L;
        }
        static String code() {
            return "settleStaticsOrderRel";
        }
        TypedField<Long> SETTLESTATICSID = new TypedField<>(Long.class, "settleStaticsId");
        TypedField<Long> ORDERID = new TypedField<>(Long.class, "orderId");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeCodeBudget {
        static Long id() {
            return 1473551179818655746L;
        }
        static String code() {
            return "chargeCodeBudget";
        }
        TypedField<String> CCCODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> CCNAME = new TypedField<>(String.class, "ccName");
        TypedField<String> CCTYPE = new TypedField<>(String.class, "ccType");
        TypedField<String> OWNERCODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> OWNERNAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> CFOCODE = new TypedField<>(String.class, "cfoCode");
        TypedField<String> CFONAME = new TypedField<>(String.class, "cfoName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CCTYPECODE = new TypedField<>(String.class, "ccTypeCode");
        TypedField<String> LEVELONEDEPARTMENTNAME = new TypedField<>(String.class, "levelOneDepartmentName");
        TypedField<String> LEVELONEDEPARTMENTCODE = new TypedField<>(String.class, "levelOneDepartmentCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> REQUESTID = new TypedField<>(String.class, "requestId");
        TypedField<String> PUSHTIME = new TypedField<>(String.class, "pushTime");
        TypedField<Long> CCCREATEUSERID = new TypedField<>(Long.class, "ccCreateUserId");
        TypedField<String> CCCREATEUSERNAME = new TypedField<>(String.class, "ccCreateUserName");
        TypedField<Long> CCUPDATEUSERID = new TypedField<>(Long.class, "ccUpdateUserId");
        TypedField<String> CCUPDATEUSERNAME = new TypedField<>(String.class, "ccUpdateUserName");
        TypedField<String> APPROVEDATE = new TypedField<>(String.class, "approveDate");
        TypedField<String> INVALIDDATE = new TypedField<>(String.class, "invalidDate");
        TypedField<LocalDateTime> APPROVEDATEWEB = new TypedField<>(LocalDateTime.class, "approveDateWeb");
        TypedField<LocalDateTime> INVALIDDATEWEB = new TypedField<>(LocalDateTime.class, "invalidDateWeb");
    }

    public interface Organize {
        static Long id() {
            return 1473561617230913537L;
        }
        static String code() {
            return "organize";
        }
        TypedField<String> ORGCODE = new TypedField<>(String.class, "orgCode");
        TypedField<String> OWNERNAME = new TypedField<>(String.class, "ownerName");
        TypedField<String> OWNERNO = new TypedField<>(String.class, "ownerNo");
        TypedField<String> PARENTORGNAME = new TypedField<>(String.class, "parentOrgName");
        TypedField<String> PARENTORGCODE = new TypedField<>(String.class, "parentOrgCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ORGNAME = new TypedField<>(String.class, "orgName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ESTABLISHDATE = new TypedField<>(String.class, "establishDate");
        TypedField<String> CHANGEDATE = new TypedField<>(String.class, "changeDate");
        TypedField<String> ORGLEVEL = new TypedField<>(String.class, "orgLevel");
        TypedField<String> ORGLEVELSERIA = new TypedField<>(String.class, "orgLevelSeria");
        TypedField<String> ORGID = new TypedField<>(String.class, "orgId");
        TypedField<String> OWNERID = new TypedField<>(String.class, "ownerId");
        TypedField<String> PARENTORGID = new TypedField<>(String.class, "parentOrgId");
        TypedField<LocalDateTime> ESTABLISHDATEWEB = new TypedField<>(LocalDateTime.class, "establishDateWeb");
        TypedField<LocalDateTime> CHANGEDATEWEB = new TypedField<>(LocalDateTime.class, "changeDateWeb");
    }

    public interface ChargeCodeBudgetDetail {
        static Long id() {
            return 1473849458675421185L;
        }
        static String code() {
            return "chargeCodeBudgetDetail";
        }
        TypedField<String> BUDGETDESC = new TypedField<>(String.class, "budgetDesc");
        TypedField<String> BUDGETAMOUNT = new TypedField<>(String.class, "budgetAmount");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CCCODE = new TypedField<>(String.class, "ccCode");
        TypedField<String> BUDGETTYPE = new TypedField<>(String.class, "budgetType");
    }

    public interface PmsMateData {
        static Long id() {
            return 1474187323395461122L;
        }
        static String code() {
            return "pmsMateData";
        }
        TypedField<String> PMSCODE = new TypedField<>(String.class, "pmsCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> OWNERCODE = new TypedField<>(String.class, "ownerCode");
        TypedField<String> PUSHTIME = new TypedField<>(String.class, "pushTime");
        TypedField<String> BODY = new TypedField<>(String.class, "body");
        TypedField<String> REQUESTID = new TypedField<>(String.class, "requestId");
    }

    public interface IncomeDetailOrderRel {
        static Long id() {
            return 1474197210030673922L;
        }
        static String code() {
            return "incomeDetailOrderRel";
        }
        TypedField<Long> INCOMEDETAILID = new TypedField<>(Long.class, "incomeDetailId");
        TypedField<Long> ORDERID = new TypedField<>(Long.class, "orderId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
    }

    public interface MemberInfo {
        static Long id() {
            return 1475703079099883521L;
        }
        static String code() {
            return "memberInfo";
        }
        TypedField<String> MEMBER_NAME = new TypedField<>(String.class, "member_name");
        TypedField<String> MEMBER_CODE = new TypedField<>(String.class, "member_code");
        TypedField<String> BELONGS_COMPANY = new TypedField<>(String.class, "belongs_company");
        TypedField<String> BELONGS_COMPANY_TAX_NO = new TypedField<>(String.class, "belongs_company_tax_no");
        TypedField<String> COMPANY_EMAIL_ADDRESS = new TypedField<>(String.class, "company_email_address");
        TypedField<String> MEMBER_PHONE_NO = new TypedField<>(String.class, "member_phone_no");
        TypedField<String> MEMBER_STATUS = new TypedField<>(String.class, "member_status");
        TypedField<String> BELONGS_DEPARTMENT = new TypedField<>(String.class, "belongs_department");
        TypedField<String> PRIMARY_LEADER_CODE = new TypedField<>(String.class, "primary_leader_code");
        TypedField<String> PRIMARY_LEADER_NAME = new TypedField<>(String.class, "primary_leader_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_NAME = new TypedField<>(String.class, "level_one_department_name");
        TypedField<String> YKB_SYNC_ID = new TypedField<>(String.class, "ykb_sync_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_CODE = new TypedField<>(String.class, "level_one_department_code");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_NAME = new TypedField<>(String.class, "level_one_department_owner_name");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_CODE = new TypedField<>(String.class, "level_one_department_owner_code");
        TypedField<String> MEMBER_LEVEL = new TypedField<>(String.class, "member_level");
        TypedField<String> BELONGS_DEPARTMENT_CODE = new TypedField<>(String.class, "belongs_department_code");
        TypedField<String> IS_OUTER = new TypedField<>(String.class, "is_outer");
        TypedField<String> INDUCTION_TIME = new TypedField<>(String.class, "induction_time");
        TypedField<String> LEAVE_TIME = new TypedField<>(String.class, "leave_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SYNC_TIME = new TypedField<>(String.class, "sync_time");
        TypedField<Long> USER_ID = new TypedField<>(Long.class, "user_id");
        TypedField<String> BELONGS_COMPANY_SEIRA = new TypedField<>(String.class, "belongs_company_seira");
        TypedField<String> PRIMARY_LEADER_USER_ID = new TypedField<>(String.class, "primary_leader_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_OWNER_USER_ID = new TypedField<>(String.class, "level_one_department_owner_user_id");
        TypedField<String> LEVEL_ONE_DEPARTMENT_ID = new TypedField<>(String.class, "level_one_department_id");
        TypedField<String> BELONGS_DEPARTMENT_ID = new TypedField<>(String.class, "belongs_department_id");
        TypedField<LocalDateTime> INDUCTION_TIME_WEB = new TypedField<>(LocalDateTime.class, "induction_time_web");
        TypedField<LocalDateTime> LEAVE_TIME_WEB = new TypedField<>(LocalDateTime.class, "leave_time_web");
    }

    public interface FinancialSyncWindow {
        static Long id() {
            return 1476437584449032194L;
        }
        static String code() {
            return "financialSyncWindow";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> SYNCTIME = new TypedField<>(String.class, "syncTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
    }

    public interface ChargeCodePrimeCost {
        static Long id() {
            return 1479004481472352258L;
        }
        static String code() {
            return "chargeCodePrimeCost";
        }
        TypedField<String> PROJECTMONTH = new TypedField<>(String.class, "projectMonth");
        TypedField<String> CHARGECODE = new TypedField<>(String.class, "chargeCode");
        TypedField<String> CHARGECODENAME = new TypedField<>(String.class, "chargeCodeName");
        TypedField<String> CHARGECODEDESC = new TypedField<>(String.class, "chargeCodeDesc");
        TypedField<String> DEPARTMENTCODE = new TypedField<>(String.class, "departmentCode");
        TypedField<String> DEPARTMENTNAME = new TypedField<>(String.class, "departmentName");
        TypedField<String> TOTALAMOUNT = new TypedField<>(String.class, "totalAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PROJECTMONTHTIME = new TypedField<>(String.class, "projectMonthTime");
        TypedField<String> TOTALAMOUNTWEB = new TypedField<>(String.class, "totalAmountWeb");
    }

    public interface OrderTaxRelation {
        static Long id() {
            return 1481437369255256065L;
        }
        static String code() {
            return "orderTaxRelation";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAXCHARGESTARTDATE = new TypedField<>(String.class, "taxChargeStartDate");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> WAITAMOUNT = new TypedField<>(BigDecimal.class, "waitAmount");
        TypedField<BigDecimal> READYAMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
    }

    public interface OrderBillRelation {
        static Long id() {
            return 1481437684166479873L;
        }
        static String code() {
            return "orderBillRelation";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> BILLDETAILNO = new TypedField<>(String.class, "billDetailNo");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> HANDLESTATUS = new TypedField<>(String.class, "handleStatus");
    }

    public interface OrderInvoiceRelation {
        static Long id() {
            return 1481437944976691201L;
        }
        static String code() {
            return "orderInvoiceRelation";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> WAITAMOUNT = new TypedField<>(String.class, "waitAmount");
        TypedField<String> READYAMOUNT = new TypedField<>(String.class, "readyAmount");
        TypedField<BigDecimal> INVOICEOPENAMOUNT = new TypedField<>(BigDecimal.class, "invoiceOpenAmount");
    }

    public interface OrderInfo {
        static Long id() {
            return 1481443933895528450L;
        }
        static String code() {
            return "orderInfo";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRICINGUNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<String> ORDERSTATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> CONTRACTID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATEDCONTRACTID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> PURCHASEQUANTITY = new TypedField<>(BigDecimal.class, "purchaseQuantity");
        TypedField<String> TOTALAMOUNTSTR = new TypedField<>(String.class, "totalAmountStr");
        TypedField<BigDecimal> PAYMENTPERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> PAYMENTTYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> SERVICETYPE = new TypedField<>(String.class, "serviceType");
        TypedField<Boolean> ISRETENTIONMONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> WAITINGAMOUNT = new TypedField<>(String.class, "waitingAmount");
        TypedField<String> READYAMOUNT = new TypedField<>(String.class, "readyAmount");
        TypedField<String> DISCOUNTAMOUNTWITHTAX = new TypedField<>(String.class, "discountAmountWithTax");
        TypedField<String> PAYABLEAMOUNTWITHTAX = new TypedField<>(String.class, "payableAmountWithTax");
        TypedField<String> RECEIVABLEAMOUNTWITHTAX = new TypedField<>(String.class, "receivableAmountWithTax");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> UNITPRICEWITHOUTTAX = new TypedField<>(String.class, "unitPriceWithoutTax");
        TypedField<String> ORDERINVOICESTATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> GENERATEDATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<LocalDateTime> EFFECTIVEDATE = new TypedField<>(LocalDateTime.class, "effectiveDate");
        TypedField<LocalDateTime> EXPIRYDATE = new TypedField<>(LocalDateTime.class, "expiryDate");
        TypedField<String> PAYTYPE = new TypedField<>(String.class, "payType");
        TypedField<String> PAYMENTCONDITION = new TypedField<>(String.class, "paymentCondition");
        TypedField<Long> CENTRALTENANTID = new TypedField<>(Long.class, "centralTenantId");
        TypedField<String> CENTRALTENANTNAME = new TypedField<>(String.class, "centralTenantName");
        TypedField<String> CENTRALTENANTCODE = new TypedField<>(String.class, "centralTenantCode");
        TypedField<BigDecimal> INORDERINVOICEDAMOUNT = new TypedField<>(BigDecimal.class, "inOrderInvoicedAmount");
        TypedField<BigDecimal> INORDERNOINVOICEDAMOUNT = new TypedField<>(BigDecimal.class, "inOrderNoInvoicedAmount");
        TypedField<String> ORIGINCONTRACTID = new TypedField<>(String.class, "originContractId");
        TypedField<String> PAYSTATUS = new TypedField<>(String.class, "payStatus");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> ORDERTYPE = new TypedField<>(String.class, "orderType");
        TypedField<BigDecimal> REMAINDEDUCTAMOUNT = new TypedField<>(BigDecimal.class, "remainDeductAmount");
        TypedField<String> ORIGINREMAINDEDUCTAMOUTNORDER = new TypedField<>(String.class, "originRemainDeductAmoutnOrder");
    }

    public interface BillStatics {
        static Long id() {
            return 1481470809122721793L;
        }
        static String code() {
            return "billStatics";
        }
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<BigDecimal> ORDERTOTALAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "orderTotalAmountWithTax");
        TypedField<BigDecimal> INVOICEAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<BigDecimal> REFUNDAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "refundAmountWithTax");
        TypedField<String> REGIONCODE = new TypedField<>(String.class, "regionCode");
        TypedField<String> REGIONNAME = new TypedField<>(String.class, "regionName");
        TypedField<String> BUSINESSUNIT = new TypedField<>(String.class, "businessUnit");
        TypedField<String> PRINCIPALPERSON = new TypedField<>(String.class, "principalPerson");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> SACHARGECODE = new TypedField<>(String.class, "saChargeCode");
        TypedField<String> CUSTOMERSIGNATORYNAME = new TypedField<>(String.class, "customerSignatoryName");
        TypedField<String> SACHARGECODENAME = new TypedField<>(String.class, "saChargeCodeName");
        TypedField<String> PROJECTNAME = new TypedField<>(String.class, "projectName");
        TypedField<String> PAYMENTTYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> TOTALORDERAMOUNTWITHTAX = new TypedField<>(String.class, "totalOrderAmountWithTax");
        TypedField<String> ORIGINCONTRACTID = new TypedField<>(String.class, "originContractId");
    }

    public interface BillStaticsDetail {
        static Long id() {
            return 1481471899815907330L;
        }
        static String code() {
            return "billStaticsDetail";
        }
        TypedField<String> BILLDETAILNO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> SALEPRICEWITHOUTTAX = new TypedField<>(String.class, "salePriceWithoutTax");
        TypedField<String> UNITAMOUNTWITHOUTTAX = new TypedField<>(String.class, "unitAmountWithoutTax");
        TypedField<String> CURRENTPAYABLEAMOUNTWITHTAX = new TypedField<>(String.class, "currentPayableAmountWithTax");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> WAITINGAMOUNT = new TypedField<>(String.class, "waitingAmount");
        TypedField<String> READYAMOUNT = new TypedField<>(String.class, "readyAmount");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PAYMENTTYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> CHARGEUNIT = new TypedField<>(String.class, "chargeUnit");
        TypedField<Long> CHARGEDAYS = new TypedField<>(Long.class, "chargeDays");
        TypedField<String> CHARGECYCLE = new TypedField<>(String.class, "chargeCycle");
        TypedField<LocalDateTime> BILLCREATEDATE = new TypedField<>(LocalDateTime.class, "billCreateDate");
        TypedField<String> INVOICECOMPANYNAME = new TypedField<>(String.class, "invoiceCompanyName");
        TypedField<String> INVOICECOMPANYTAXNO = new TypedField<>(String.class, "invoiceCompanyTaxNo");
        TypedField<LocalDateTime> INVOICEGENERATEDATE = new TypedField<>(LocalDateTime.class, "invoiceGenerateDate");
        TypedField<BigDecimal> INVOICEAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithoutTax");
        TypedField<BigDecimal> INVOICEAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "invoiceAmountWithTax");
        TypedField<String> PAYMENTCOMPANY = new TypedField<>(String.class, "paymentCompany");
        TypedField<BigDecimal> CURRENTDISCOUNTAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "currentDiscountAmountWithTax");
        TypedField<LocalDateTime> PAYBACKDATE = new TypedField<>(LocalDateTime.class, "payBackDate");
        TypedField<BigDecimal> PAYBACKAMOUNT = new TypedField<>(BigDecimal.class, "payBackAmount");
        TypedField<String> DATATYPE = new TypedField<>(String.class, "dataType");
        TypedField<BigDecimal> COMPENSATEAMOUNT = new TypedField<>(BigDecimal.class, "compensateAmount");
        TypedField<BigDecimal> CURRENTPAYABLEAMOUNTAFTERDISCOUNTWITHTAX = new TypedField<>(BigDecimal.class, "currentPayableAmountAfterDiscountWithTax");
        TypedField<BigDecimal> CURRENTPAYABLEAMOUNTAFTERDISCOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "currentPayableAmountAfterDiscountWithoutTax");
        TypedField<BigDecimal> ORDERTOTALAMOUNT = new TypedField<>(BigDecimal.class, "orderTotalAmount");
        TypedField<BigDecimal> ORDERWAITAMOUNT = new TypedField<>(BigDecimal.class, "orderWaitAmount");
        TypedField<BigDecimal> ORDERREADYAMOUNT = new TypedField<>(BigDecimal.class, "orderReadyAmount");
        TypedField<BigDecimal> INVOICEWAITAMOUNT = new TypedField<>(BigDecimal.class, "invoiceWaitAmount");
        TypedField<BigDecimal> INVOICEREADYAMOUNT = new TypedField<>(BigDecimal.class, "invoiceReadyAmount");
        TypedField<BigDecimal> TAXWAITAMOUNT = new TypedField<>(BigDecimal.class, "taxWaitAmount");
        TypedField<BigDecimal> TAXREADYAMOUNT = new TypedField<>(BigDecimal.class, "taxReadyAmount");
        TypedField<Boolean> ISSHOW = new TypedField<>(Boolean.class, "isShow");
        TypedField<String> INDEXTRADENO = new TypedField<>(String.class, "indexTradeNo");
        TypedField<String> TRADESHAREINFO = new TypedField<>(String.class, "tradeShareInfo");
        TypedField<LocalDateTime> ORDERGENERATEDATE = new TypedField<>(LocalDateTime.class, "orderGenerateDate");
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> REDUCEDAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "reducedAmountWithTax");
    }

    public interface Bill {
        static Long id() {
            return 1481525805784682498L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<LocalDateTime> GENERATEDATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<String> RECONCILIATIONSTATUS = new TypedField<>(String.class, "reconciliationStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> HANDLESTATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<LocalDateTime> ACCOUNTINTSTARTDATE = new TypedField<>(LocalDateTime.class, "accountintStartDate");
        TypedField<LocalDateTime> ACCOUNTINTENDDATE = new TypedField<>(LocalDateTime.class, "accountintEndDate");
        TypedField<BigDecimal> BILLAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "billAmountWithTax");
        TypedField<BigDecimal> DISCOUNTAMOUNTWITHTAX = new TypedField<>(BigDecimal.class, "discountAmountWithTax");
        TypedField<String> BTENANTCODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> BTENANTNAME = new TypedField<>(String.class, "bTenantName");
        TypedField<Long> BTENANTID = new TypedField<>(Long.class, "bTenantId");
        TypedField<BigDecimal> PAYMENTAMOUNT = new TypedField<>(BigDecimal.class, "paymentAmount");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<Long> TAXCOUNT = new TypedField<>(Long.class, "taxCount");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> ORIGINCONTRACTNO = new TypedField<>(String.class, "originContractNo");
    }

    public interface BillDetail {
        static Long id() {
            return 1481527030850785282L;
        }
        static String code() {
            return "billDetail";
        }
        TypedField<String> BILLDETAILNO = new TypedField<>(String.class, "billDetailNo");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTNO = new TypedField<>(String.class, "productNo");
        TypedField<String> CHARGETYPE = new TypedField<>(String.class, "chargeType");
        TypedField<String> PAYMENTMETHOD = new TypedField<>(String.class, "paymentMethod");
        TypedField<String> SALEPRICEWITHOUTTAX = new TypedField<>(String.class, "salePriceWithoutTax");
        TypedField<String> UNITAMOUNTWITHOUTTAX = new TypedField<>(String.class, "unitAmountWithoutTax");
        TypedField<String> CURRENTPAYABLEAMOUNTWITHTAX = new TypedField<>(String.class, "currentPayableAmountWithTax");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<LocalDateTime> ACCOUNTINGSTARTDATE = new TypedField<>(LocalDateTime.class, "accountingStartDate");
        TypedField<LocalDateTime> ACCOUNTINGENDDATE = new TypedField<>(LocalDateTime.class, "accountingEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> BTENANTCODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<Long> BTENANTID = new TypedField<>(Long.class, "bTenantId");
        TypedField<LocalDateTime> TAXBILLINGDATE = new TypedField<>(LocalDateTime.class, "taxBillingDate");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> DISCOUNTAMOUNT = new TypedField<>(String.class, "discountAmount");
        TypedField<String> CURRENTPAYABLEAMOUNTWITHTAXAFTERDISCOUNT = new TypedField<>(String.class, "currentPayableAmountWithTaxAfterDiscount");
        TypedField<String> CURRENTPAYABLEAMOUNTWITHOUTTAXAFTERDISCOUNT = new TypedField<>(String.class, "currentPayableAmountWithoutTaxAfterDiscount");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> HANDLESTATUS = new TypedField<>(String.class, "handleStatus");
        TypedField<String> ORIGINCONTRACTID = new TypedField<>(String.class, "originContractId");
        TypedField<String> REDUCEDAMOUNTWITHTAX = new TypedField<>(String.class, "reducedAmountWithTax");
    }

    public interface IncomeSummary {
        static Long id() {
            return 1481539368520966145L;
        }
        static String code() {
            return "incomeSummary";
        }
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> PRICINGUNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> RECEIPTDATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USINGMONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTINGPERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> CURRENTPERIODINCOMEAMOUNT = new TypedField<>(BigDecimal.class, "currentPeriodIncomeAmount");
        TypedField<String> INCOMESTATUS = new TypedField<>(String.class, "incomeStatus");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<Long> PRODUCTINCOMEEFFECTIVEDAY = new TypedField<>(Long.class, "productIncomeEffectiveDay");
        TypedField<String> PRODUCTINCOMEBALANCE = new TypedField<>(String.class, "productIncomeBalance");
        TypedField<Long> PRODUCTINCOMEUSAGECOUNT1 = new TypedField<>(Long.class, "productIncomeUsageCount1");
        TypedField<String> PRODUCTINCOMEDAYAMOUNT = new TypedField<>(String.class, "productIncomeDayAmount");
        TypedField<String> CONFIRMTYPE = new TypedField<>(String.class, "confirmType");
        TypedField<String> PRODUCTINCOMETYPE = new TypedField<>(String.class, "productIncomeType");
        TypedField<LocalDateTime> USINGMONTHDATE = new TypedField<>(LocalDateTime.class, "usingMonthDate");
        TypedField<String> BILLMONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> ACCOUNTINGPERIODSTR = new TypedField<>(String.class, "accountingPeriodStr");
    }

    public interface IncomeItem {
        static Long id() {
            return 1481546350567804929L;
        }
        static String code() {
            return "incomeItem";
        }
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> RELATEDORDERNOS = new TypedField<>(String.class, "relatedOrderNos");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> PROPERTY = new TypedField<>(String.class, "property");
        TypedField<String> PRICINGUNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<LocalDateTime> CHARGESTARTDATE = new TypedField<>(LocalDateTime.class, "chargeStartDate");
        TypedField<LocalDateTime> CHARGEENDDATE = new TypedField<>(LocalDateTime.class, "chargeEndDate");
        TypedField<Long> USINGMONTH = new TypedField<>(Long.class, "usingMonth");
        TypedField<Long> ACCOUNTINGPERIOD = new TypedField<>(Long.class, "accountingPeriod");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> CURRENTPERIODAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "currentPeriodAmountWithoutTax");
        TypedField<LocalDateTime> STARTDATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> ENDDATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> RELATEDORDERNO = new TypedField<>(String.class, "relatedOrderNo");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<Long> PRODUCTINCOMEEFFECTIVEDAY = new TypedField<>(Long.class, "productIncomeEffectiveDay");
        TypedField<BigDecimal> PRODUCTINCOMEBALANCE = new TypedField<>(BigDecimal.class, "productIncomeBalance");
        TypedField<BigDecimal> PRODUCTINCOMEDAYAMOUNT = new TypedField<>(BigDecimal.class, "productIncomeDayAmount");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<LocalDateTime> RECEIPTDATE = new TypedField<>(LocalDateTime.class, "receiptDate");
        TypedField<String> DISCOUNTAMOUNTWITHTAX = new TypedField<>(String.class, "discountAmountWithTax");
        TypedField<LocalDateTime> USINGMONTHDATE = new TypedField<>(LocalDateTime.class, "usingMonthDate");
        TypedField<String> PRODUCTINCOMETYPE = new TypedField<>(String.class, "productIncomeType");
        TypedField<BigDecimal> UNITPRICEWITHOUTTAX = new TypedField<>(BigDecimal.class, "unitPriceWithoutTax");
        TypedField<String> BILLMONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> ACCOUNTINGPERIODSTR = new TypedField<>(String.class, "accountingPeriodStr");
    }

    public interface BillTaxUsage {
        static Long id() {
            return 1482962910322065410L;
        }
        static String code() {
            return "billTaxUsage";
        }
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractNo");
        TypedField<String> BILLNO = new TypedField<>(String.class, "billNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> TAXCOMPANYNAME = new TypedField<>(String.class, "taxCompanyName");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> CHARGEBIZDIMENSION = new TypedField<>(String.class, "chargeBizDimension");
        TypedField<String> ACTUALBIZVOLUME = new TypedField<>(String.class, "actualBizVolume");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> BIZMONTH = new TypedField<>(Long.class, "bizMonth");
        TypedField<LocalDateTime> ACCOUNTINTSTARTDATE = new TypedField<>(LocalDateTime.class, "accountintStartDate");
        TypedField<LocalDateTime> ACCOUNTINTENDDATE = new TypedField<>(LocalDateTime.class, "accountintEndDate");
        TypedField<Long> DETAILNO = new TypedField<>(Long.class, "detailNo");
        TypedField<Long> BTENANTID = new TypedField<>(Long.class, "bTenantId");
        TypedField<String> BTENANTNAME = new TypedField<>(String.class, "bTenantName");
        TypedField<String> BTENANTCODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<Long> BILLINGTYPE = new TypedField<>(Long.class, "billingType");
        TypedField<LocalDateTime> BCREATETIME = new TypedField<>(LocalDateTime.class, "bcreateTime");
        TypedField<String> BDETAILNO = new TypedField<>(String.class, "bDetailNo");
    }

    public interface OrderInfoRawData {
        static Long id() {
            return 1493840515636101121L;
        }
        static String code() {
            return "orderInfoRawData";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> CONTRACTID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATELDCONTRACTID = new TypedField<>(String.class, "relateldContractId");
        TypedField<String> JSON = new TypedField<>(String.class, "json");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ImportBatchClaimData {
        static Long id() {
            return 1494125877503561729L;
        }
        static String code() {
            return "importBatchClaimData";
        }
        TypedField<String> TRACENO = new TypedField<>(String.class, "traceNo");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<BigDecimal> CLAIMAMOUNT = new TypedField<>(BigDecimal.class, "claimAmount");
        TypedField<String> BATCHNO = new TypedField<>(String.class, "batchNo");
        TypedField<Long> STATUS = new TypedField<>(Long.class, "status");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface CompensateData {
        static Long id() {
            return 1495652134750195713L;
        }
        static String code() {
            return "compensateData";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> COMPENSATEAMOUNT = new TypedField<>(String.class, "compensateAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
    }

    public interface MultiRelation {
        static Long id() {
            return 1496013110435454977L;
        }
        static String code() {
            return "multiRelation";
        }
        TypedField<String> TRADENO = new TypedField<>(String.class, "tradeNo");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> TAXNO = new TypedField<>(String.class, "taxNo");
        TypedField<String> INVOICECODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICENO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> READYAMOUNT = new TypedField<>(BigDecimal.class, "readyAmount");
    }

    public interface OrderRawData {
        static Long id() {
            return 1498956659078664193L;
        }
        static String code() {
            return "orderRawData";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> CONTRACTID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATEDCONTRACTID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> JSON = new TypedField<>(String.class, "json");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ChargeMonthData {
        static Long id() {
            return 1502518601290551297L;
        }
        static String code() {
            return "chargeMonthData";
        }
        TypedField<String> CONTRACTCODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TENANTCODE = new TypedField<>(String.class, "tenantCode");
        TypedField<String> TENANTNAME = new TypedField<>(String.class, "tenantName");
        TypedField<String> TAXNUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<String> SERVICEOPENFLAG = new TypedField<>(String.class, "serviceOpenFlag");
        TypedField<LocalDateTime> STARTDATE = new TypedField<>(LocalDateTime.class, "startDate");
        TypedField<LocalDateTime> ENDDATE = new TypedField<>(LocalDateTime.class, "endDate");
        TypedField<String> BILLMONTH = new TypedField<>(String.class, "billMonth");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESSCODE = new TypedField<>(String.class, "businessCode");
        TypedField<Long> USAGECOUNT = new TypedField<>(Long.class, "usageCount");
        TypedField<Long> USAGELIMITCOUNT = new TypedField<>(Long.class, "usageLimitCount");
        TypedField<BigDecimal> BILLAMOUNTWITHOUTTAX = new TypedField<>(BigDecimal.class, "billAmountWithoutTax");
        TypedField<BigDecimal> TAXRATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> PRICEUNIT = new TypedField<>(BigDecimal.class, "priceUnit");
        TypedField<Long> PAYMENTTYPE = new TypedField<>(Long.class, "paymentType");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BTENANTCODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> BTENANTNAME = new TypedField<>(String.class, "bTenantName");
        TypedField<Long> FLOWID = new TypedField<>(Long.class, "flowId");
        TypedField<String> TAXNUMPK = new TypedField<>(String.class, "taxNumPk");
        TypedField<LocalDateTime> TAXSTARTDATE = new TypedField<>(LocalDateTime.class, "taxStartDate");
        TypedField<LocalDateTime> TAXENDDATE = new TypedField<>(LocalDateTime.class, "taxEndDate");
        TypedField<String> ORIGINCONTRACTCODE = new TypedField<>(String.class, "originContractCode");
        TypedField<String> PAYMENTTYPEENUM = new TypedField<>(String.class, "paymentTypeEnum");
    }

    public interface BillDetailMonth {
        static Long id() {
            return 1503318639658631169L;
        }
        static String code() {
            return "billDetailMonth";
        }
        TypedField<Long> BILLCYCLEID = new TypedField<>(Long.class, "billCycleId");
        TypedField<String> CONTRACTCODE = new TypedField<>(String.class, "contractCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> TAXNUM = new TypedField<>(String.class, "taxNum");
        TypedField<String> COMPANYNAME = new TypedField<>(String.class, "companyName");
        TypedField<BigDecimal> USAGECOUNT = new TypedField<>(BigDecimal.class, "usageCount");
        TypedField<LocalDateTime> BILLMONTH = new TypedField<>(LocalDateTime.class, "billMonth");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLMONTHSTR = new TypedField<>(String.class, "billMonthStr");
        TypedField<String> TAXNUMPK = new TypedField<>(String.class, "taxNumPk");
        TypedField<String> BTENANTCODE = new TypedField<>(String.class, "bTenantCode");
        TypedField<String> BTENANTNAME = new TypedField<>(String.class, "bTenantName");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<String> BUSINESSCODE = new TypedField<>(String.class, "businessCode");
        TypedField<String> ORIGINCONTRACTCODE = new TypedField<>(String.class, "originContractCode");
    }

    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1511647092132646913L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface UntreatedOrderInfo {
        static Long id() {
            return 1511672926537093121L;
        }
        static String code() {
            return "untreatedOrderInfo";
        }
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> PRICINGUNIT = new TypedField<>(String.class, "pricingUnit");
        TypedField<Long> VERSION = new TypedField<>(Long.class, "version");
        TypedField<String> ORDERSTATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> CONTRACTID = new TypedField<>(String.class, "contractId");
        TypedField<String> RELATEDCONTRACTID = new TypedField<>(String.class, "relatedContractId");
        TypedField<String> PRODUCTCODE = new TypedField<>(String.class, "productCode");
        TypedField<String> PRODUCTNAME = new TypedField<>(String.class, "productName");
        TypedField<BigDecimal> PURCHASEQUANTITY = new TypedField<>(BigDecimal.class, "purchaseQuantity");
        TypedField<String> TOTALAMOUNTSTR = new TypedField<>(String.class, "totalAmountStr");
        TypedField<BigDecimal> PAYMENTPERCENT = new TypedField<>(BigDecimal.class, "paymentPercent");
        TypedField<String> PAYMENTTYPE = new TypedField<>(String.class, "paymentType");
        TypedField<String> SERVICETYPE = new TypedField<>(String.class, "serviceType");
        TypedField<Boolean> ISRETENTIONMONEY = new TypedField<>(Boolean.class, "isRetentionMoney");
        TypedField<String> PAYMENTREQUIREMENT = new TypedField<>(String.class, "paymentRequirement");
        TypedField<String> WAITINGAMOUNT = new TypedField<>(String.class, "waitingAmount");
        TypedField<String> READYAMOUNT = new TypedField<>(String.class, "readyAmount");
        TypedField<String> DISCOUNTAMOUNTWITHTAX = new TypedField<>(String.class, "discountAmountWithTax");
        TypedField<String> PAYABLEAMOUNTWITHTAX = new TypedField<>(String.class, "payableAmountWithTax");
        TypedField<String> RECEIVABLEAMOUNTWITHTAX = new TypedField<>(String.class, "receivableAmountWithTax");
        TypedField<String> TAXRATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> UNITPRICEWITHOUTTAX = new TypedField<>(String.class, "unitPriceWithoutTax");
        TypedField<String> ORDERINVOICESTATUS = new TypedField<>(String.class, "orderInvoiceStatus");
        TypedField<LocalDateTime> GENERATEDATE = new TypedField<>(LocalDateTime.class, "generateDate");
        TypedField<LocalDateTime> EFFECTIVEDATE = new TypedField<>(LocalDateTime.class, "effectiveDate");
        TypedField<LocalDateTime> EXPIRYDATE = new TypedField<>(LocalDateTime.class, "expiryDate");
        TypedField<String> PAYTYPE = new TypedField<>(String.class, "payType");
        TypedField<String> PAYMENTCONDITION = new TypedField<>(String.class, "paymentCondition");
        TypedField<Long> CENTRALTENANTID = new TypedField<>(Long.class, "centralTenantId");
        TypedField<String> CENTRALTENANTNAME = new TypedField<>(String.class, "centralTenantName");
        TypedField<String> CENTRALTENANTCODE = new TypedField<>(String.class, "centralTenantCode");
        TypedField<BigDecimal> INORDERINVOICEDAMOUNT = new TypedField<>(BigDecimal.class, "inOrderInvoicedAmount");
        TypedField<BigDecimal> INORDERNOINVOICEDAMOUNT = new TypedField<>(BigDecimal.class, "inOrderNoInvoicedAmount");
        TypedField<String> ORIGINCONTRACTID = new TypedField<>(String.class, "originContractId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILLINGTYPE = new TypedField<>(String.class, "billingType");
        TypedField<BigDecimal> REMAINDEDUCTAMOUNT = new TypedField<>(BigDecimal.class, "remainDeductAmount");
        TypedField<String> ORIGINREMAINDEDUCTAMOUTNORDER = new TypedField<>(String.class, "originRemainDeductAmoutnOrder");
    }

}
