package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计费周期
 * </p>
 *
 * @author ultraman
 * @since 2022-05-05
 */
public enum ChargeCycleEnum {

    NULL("null", "待维护");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCycleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCycleEnum fromCode(String code){
        switch(code) {
            case "null":
                return NULL;
            default:
                return null;
        }
    }
}
