package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 使用发票类型
 * </p>
 *
 * @author ultraman
 * @since 2021-08-31
 */
public enum UseInvoiceType {

    _0("0", "无"),
    _1("1", "通用"),
    _2("2", "除增值税电子普通发票外所有发票"),
    _3("3", "增值税电子普通发票"),
    _4("4", "增值税专用发票"),
    _5("5", "增值税普通发票、增值税电子普通发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    UseInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UseInvoiceType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
