package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceData implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("invoiceCode")
  private String invoiceCode;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("originalInvoiceCode")
  private String originalInvoiceCode;

  @TableField("originalInvoiceNo")
  private String originalInvoiceNo;

  @TableField("statementNo")
  private String statementNo;

  @TableField("sellerTaxName")
  private String sellerTaxName;

  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("invoiceMoneyWithTax")
  private BigDecimal invoiceMoneyWithTax;

  @TableField("invoiceMoneyWithoutTax")
  private BigDecimal invoiceMoneyWithoutTax;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("effectiveStatus")
  private String effectiveStatus;

  @TableField("invoiceStatus")
  private String invoiceStatus;

  private String remark;

  @TableField("buyerName")
  private String buyerName;

  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  @TableField("matchStatus")
  private String matchStatus;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("invoiceDate")
  private String invoiceDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("statementNo", statementNo);
      map.put("sellerTaxName", sellerTaxName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceMoneyWithTax", invoiceMoneyWithTax);
      map.put("invoiceMoneyWithoutTax", invoiceMoneyWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("effectiveStatus", effectiveStatus);
      map.put("invoiceStatus", invoiceStatus);
      map.put("remark", remark);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("matchStatus", matchStatus);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("invoiceDate", invoiceDate);
      return map;
  }

  public static InvoiceData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceData entity = new InvoiceData();
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxName")) {
      Object obj = map.get("sellerTaxName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceMoneyWithTax")) {
      Object obj = map.get("invoiceMoneyWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceMoneyWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceMoneyWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceMoneyWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceMoneyWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceMoneyWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceMoneyWithoutTax")) {
      Object obj = map.get("invoiceMoneyWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceMoneyWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceMoneyWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceMoneyWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceMoneyWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceMoneyWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("effectiveStatus")) {
      Object obj = map.get("effectiveStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEffectiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceDate((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
