package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款条件
 * </p>
 *
 * @author ultraman
 * @since 2022-06-06
 */
public enum PaymentRequirement {

    _1("1", "合同签订"),
    _3("3", "UAT测试"),
    _2("2", "蓝图确认"),
    _4("4", "上线验收"),
    _5("5", "质保金"),
    _6("6", "开通服务"),
    _0("0", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PaymentRequirement(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaymentRequirement fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "3":
                return _3;
            case "2":
                return _2;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
