package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 台账状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2022-06-13
 */
public enum StandingBookStatusEnum {

    _1("1", "无需确认"),
    _2("2", "待确认"),
    _3("3", "已确认"),
    _4("4", "已退回"),
    _5("5", "kam确认中"),
    _6("6", "财务确认中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StandingBookStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StandingBookStatusEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
