package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialTravelApplyBill extends FinancialApplyBasicBill {


  /**
   * 出差申请单编码
   */
  @TableField("businessApplyCode")
  private String businessApplyCode;

  /**
   * 出差申请单名称
   */
  @TableField("businessApplyName")
  private String businessApplyName;

  /**
   * 补充申请单号
   */
  @TableField("replenishApplyCode")
  private String replenishApplyCode;

  /**
   * 补充申请标题
   */
  @TableField("replenishApplyName")
  private String replenishApplyName;

  /**
   * 消费开始日期
   */
  @TableField("startDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 消费结束日期
   */
  @TableField("endDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("businessApplyCode", businessApplyCode);
      map.put("businessApplyName", businessApplyName);
      map.put("replenishApplyCode", replenishApplyCode);
      map.put("replenishApplyName", replenishApplyName);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialTravelApplyBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialTravelApplyBill entity = new FinancialTravelApplyBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessApplyCode")) {
      Object obj = map.get("businessApplyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessApplyName")) {
      Object obj = map.get("businessApplyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishApplyCode")) {
      Object obj = map.get("replenishApplyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReplenishApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replenishApplyName")) {
      Object obj = map.get("replenishApplyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReplenishApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
