package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 大区
 * </p>
 *
 * @author ultraman
 * @since 2022-06-14
 */
public enum Region {

    _0("0", "华东"),
    _1("1", "南区"),
    _2("2", "北区"),
    _3("3", "中区"),
    _4("4", "GR"),
    _5("5", "总部"),
    _6("6", "光是"),
    _7("7", "数据增值服务BG筹备组");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Region(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Region fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
