package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预算类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-13
 */
public enum ChargeCodeBudgetType {

    PROJECT("project", "项目预算"),
    DEPT("dept", "部门预算");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeBudgetType fromCode(String code){
        switch(code) {
            case "project":
                return PROJECT;
            case "dept":
                return DEPT;
            default:
                return null;
        }
    }
}
