package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialReimbursementBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialBusinessServeReimbursementBill extends FinancialReimbursementBasicBill {


  /**
   * 关联申请单单号
   */
  @TableField("relevanceApplyNumber")
  private String relevanceApplyNumber;

  /**
   * 关联申请单标题
   */
  @TableField("relevanceApplyTitle")
  private String relevanceApplyTitle;

  /**
   * 招待事由及招待方式
   */
  private String cause;

  /**
   * 出差申请单编码
   */
  @TableField("businessApplyCode")
  private String businessApplyCode;

  /**
   * 出差申请单名称
   */
  @TableField("businessApplyName")
  private String businessApplyName;

  /**
   * 实际招待客户人数及职级
   */
  @TableField("actualExpectedNumberRank")
  private String actualExpectedNumberRank;

  /**
   * 备注
   */
  private String comment;

  /**
   * 预计招待客户人数及职级
   */
  @TableField("predictExpectedNumberRank")
  private String predictExpectedNumberRank;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("relevanceApplyNumber", relevanceApplyNumber);
      map.put("relevanceApplyTitle", relevanceApplyTitle);
      map.put("cause", cause);
      map.put("businessApplyCode", businessApplyCode);
      map.put("businessApplyName", businessApplyName);
      map.put("actualExpectedNumberRank", actualExpectedNumberRank);
      map.put("comment", comment);
      map.put("predictExpectedNumberRank", predictExpectedNumberRank);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialBusinessServeReimbursementBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialBusinessServeReimbursementBill entity = new FinancialBusinessServeReimbursementBill();
    if(map.containsKey("claimDate")) {
      Object obj = map.get("claimDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setClaimDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setClaimDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setClaimDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setClaimDate(null);
      }
    }
    if(map.containsKey("claimDept")) {
      Object obj = map.get("claimDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDueBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relevanceApplyNumber")) {
      Object obj = map.get("relevanceApplyNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelevanceApplyNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relevanceApplyTitle")) {
      Object obj = map.get("relevanceApplyTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelevanceApplyTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessApplyCode")) {
      Object obj = map.get("businessApplyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessApplyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessApplyName")) {
      Object obj = map.get("businessApplyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessApplyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actualExpectedNumberRank")) {
      Object obj = map.get("actualExpectedNumberRank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActualExpectedNumberRank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("comment")) {
      Object obj = map.get("comment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("predictExpectedNumberRank")) {
      Object obj = map.get("predictExpectedNumberRank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPredictExpectedNumberRank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
