package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchaseCheckBill extends FinancialApplyBasicBill {


  /**
   * 采购事项单据单号
   */
  @TableField("procurementDocumentsNo")
  private String procurementDocumentsNo;

  /**
   * 采购事项单据标题
   */
  @TableField("procurementDocumentsTitle")
  private String procurementDocumentsTitle;

  /**
   * 采购申请人编码
   */
  @TableField("procurementApplicantNumber")
  private String procurementApplicantNumber;

  /**
   * 采购申请人名称
   */
  @TableField("procurementApplicantName")
  private String procurementApplicantName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 标题
   */
  private String title;

  /**
   * 供应商编码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 采购合同台账编码
   */
  @TableField("procurementStandingCode")
  private String procurementStandingCode;

  /**
   * 采购合同台账名称
   */
  @TableField("procurementStandingName")
  private String procurementStandingName;

  /**
   * 是否验收
   */
  @TableField("isCheck")
  private String isCheck;

  /**
   * 钉钉单号
   */
  @TableField("dingDingNo")
  private String dingDingNo;

  /**
   * 发货类型编码
   */
  @TableField("sendTypeCode")
  private String sendTypeCode;

  /**
   * 发货类型名称
   */
  @TableField("sendTypeName")
  private String sendTypeName;

  /**
   * 资产大类编码
   */
  @TableField("assetCategoriesCode")
  private String assetCategoriesCode;

  /**
   * 资产大类名称
   */
  @TableField("assetCategoriesName")
  private String assetCategoriesName;

  /**
   * 资产小类编码
   */
  @TableField("assetSmallCode")
  private String assetSmallCode;

  /**
   * 资产小类名称
   */
  @TableField("assetSmallName")
  private String assetSmallName;

  /**
   * 发往大区编码
   */
  @TableField("sentRegionalCode")
  private String sentRegionalCode;

  /**
   * 发往大区名称
   */
  @TableField("sentRegionalName")
  private String sentRegionalName;

  /**
   * 验收方式编码
   */
  @TableField("checkWayCode")
  private String checkWayCode;

  /**
   * 验收方式名称
   */
  @TableField("checkWayName")
  private String checkWayName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("procurementApplicantNumber", procurementApplicantNumber);
      map.put("procurementApplicantName", procurementApplicantName);
      map.put("contractNo", contractNo);
      map.put("title", title);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("procurementStandingCode", procurementStandingCode);
      map.put("procurementStandingName", procurementStandingName);
      map.put("isCheck", isCheck);
      map.put("dingDingNo", dingDingNo);
      map.put("sendTypeCode", sendTypeCode);
      map.put("sendTypeName", sendTypeName);
      map.put("assetCategoriesCode", assetCategoriesCode);
      map.put("assetCategoriesName", assetCategoriesName);
      map.put("assetSmallCode", assetSmallCode);
      map.put("assetSmallName", assetSmallName);
      map.put("sentRegionalCode", sentRegionalCode);
      map.put("sentRegionalName", sentRegionalName);
      map.put("checkWayCode", checkWayCode);
      map.put("checkWayName", checkWayName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialPurchaseCheckBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchaseCheckBill entity = new FinancialPurchaseCheckBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementApplicantNumber")) {
      Object obj = map.get("procurementApplicantNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementApplicantNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementApplicantName")) {
      Object obj = map.get("procurementApplicantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementApplicantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("title")) {
      Object obj = map.get("title");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementStandingCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementStandingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isCheck")) {
      Object obj = map.get("isCheck");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dingDingNo")) {
      Object obj = map.get("dingDingNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDingDingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendTypeCode")) {
      Object obj = map.get("sendTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendTypeName")) {
      Object obj = map.get("sendTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSendTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetCategoriesCode")) {
      Object obj = map.get("assetCategoriesCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssetCategoriesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetCategoriesName")) {
      Object obj = map.get("assetCategoriesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssetCategoriesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetSmallCode")) {
      Object obj = map.get("assetSmallCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssetSmallCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetSmallName")) {
      Object obj = map.get("assetSmallName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssetSmallName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sentRegionalCode")) {
      Object obj = map.get("sentRegionalCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSentRegionalCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sentRegionalName")) {
      Object obj = map.get("sentRegionalName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSentRegionalName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayCode")) {
      Object obj = map.get("checkWayCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkWayName")) {
      Object obj = map.get("checkWayName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
