package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchasePaymentBill extends FinancialApplyBasicBill {


  /**
   * 关联采购申请单单号
   */
  @TableField("relevanceProcurementApplyNo")
  private String relevanceProcurementApplyNo;

  /**
   * 关联采购申请单标题
   */
  @TableField("relevanceProcurementApplyTitle")
  private String relevanceProcurementApplyTitle;

  /**
   * 采购事项单据单号
   */
  @TableField("procurementDocumentsNo")
  private String procurementDocumentsNo;

  /**
   * 采购事项单据标题
   */
  @TableField("procurementDocumentsTitle")
  private String procurementDocumentsTitle;

  /**
   * 核票责任人编码
   */
  @TableField("responsibleCode")
  private String responsibleCode;

  /**
   * 核票责任人名称
   */
  @TableField("responsibleName")
  private String responsibleName;

  /**
   * 提交人编码
   */
  @TableField("submitterCode")
  private String submitterCode;

  /**
   * 提交人名称
   */
  @TableField("submitterName")
  private String submitterName;

  /**
   * 申请部门
   */
  @TableField("applicationDept")
  private String applicationDept;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 付款事由
   */
  @TableField("payCause")
  private String payCause;

  /**
   * 供应商编码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 采购合同台账编码
   */
  @TableField("procurementStandingCode")
  private String procurementStandingCode;

  /**
   * 采购合同台账名称
   */
  @TableField("procurementStandingName")
  private String procurementStandingName;

  /**
   * 付款类型编码
   */
  @TableField("payTypeCode")
  private String payTypeCode;

  /**
   * 付款类型名称
   */
  @TableField("payTypeName")
  private String payTypeName;

  /**
   * 项目档案编码
   */
  @TableField("projectArchivesCode")
  private String projectArchivesCode;

  /**
   * 项目档案名称
   */
  @TableField("projectArchivesName")
  private String projectArchivesName;

  /**
   * 收款银行
   */
  @TableField("dueBank")
  private String dueBank;

  /**
   * 收款账号
   */
  @TableField("accountNumber")
  private String accountNumber;

  /**
   * 收款人
   */
  private String payee;

  /**
   * 采购阶段编码
   */
  @TableField("acquisitionPhaseCode")
  private String acquisitionPhaseCode;

  /**
   * 采购阶段名称
   */
  @TableField("acquisitionPhaseName")
  private String acquisitionPhaseName;

  /**
   * 采购类别编码
   */
  @TableField("procurementTypeCode")
  private String procurementTypeCode;

  /**
   * 采购类别名称
   */
  @TableField("procurementTypeName")
  private String procurementTypeName;

  /**
   * 付款主体编码
   */
  @TableField("paymentCode")
  private String paymentCode;

  /**
   * 付款主体名称
   */
  @TableField("paymentName")
  private String paymentName;

  /**
   * 签约主体
   */
  @TableField("contractParty")
  private String contractParty;

  /**
   * 采购方式编码
   */
  @TableField("procurementWayCode")
  private String procurementWayCode;

  /**
   * 采购方式名称
   */
  @TableField("procurementWayName")
  private String procurementWayName;

  /**
   * 法人实体编码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 法人实体名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 一级部门
   */
  @TableField("oneDept")
  private String oneDept;

  /**
   * 采购目的编码
   */
  @TableField("procurementPurposesCode")
  private String procurementPurposesCode;

  /**
   * 采购目的名称
   */
  @TableField("procurementPurposesName")
  private String procurementPurposesName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("relevanceProcurementApplyNo", relevanceProcurementApplyNo);
      map.put("relevanceProcurementApplyTitle", relevanceProcurementApplyTitle);
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("responsibleCode", responsibleCode);
      map.put("responsibleName", responsibleName);
      map.put("submitterCode", submitterCode);
      map.put("submitterName", submitterName);
      map.put("applicationDept", applicationDept);
      map.put("contractNo", contractNo);
      map.put("payCause", payCause);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("procurementStandingCode", procurementStandingCode);
      map.put("procurementStandingName", procurementStandingName);
      map.put("payTypeCode", payTypeCode);
      map.put("payTypeName", payTypeName);
      map.put("projectArchivesCode", projectArchivesCode);
      map.put("projectArchivesName", projectArchivesName);
      map.put("dueBank", dueBank);
      map.put("accountNumber", accountNumber);
      map.put("payee", payee);
      map.put("acquisitionPhaseCode", acquisitionPhaseCode);
      map.put("acquisitionPhaseName", acquisitionPhaseName);
      map.put("procurementTypeCode", procurementTypeCode);
      map.put("procurementTypeName", procurementTypeName);
      map.put("paymentCode", paymentCode);
      map.put("paymentName", paymentName);
      map.put("contractParty", contractParty);
      map.put("procurementWayCode", procurementWayCode);
      map.put("procurementWayName", procurementWayName);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("oneDept", oneDept);
      map.put("procurementPurposesCode", procurementPurposesCode);
      map.put("procurementPurposesName", procurementPurposesName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialPurchasePaymentBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchasePaymentBill entity = new FinancialPurchasePaymentBill();
    if(map.containsKey("applicationDate")) {
      Object obj = map.get("applicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setApplicationDate(null);
      }
    }
    if(map.containsKey("applicantDept")) {
      Object obj = map.get("applicantDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyCode")) {
      Object obj = map.get("applicantCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantCompanyName")) {
      Object obj = map.get("applicantCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relevanceProcurementApplyNo")) {
      Object obj = map.get("relevanceProcurementApplyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelevanceProcurementApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relevanceProcurementApplyTitle")) {
      Object obj = map.get("relevanceProcurementApplyTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRelevanceProcurementApplyTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleCode")) {
      Object obj = map.get("responsibleCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponsibleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleName")) {
      Object obj = map.get("responsibleName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponsibleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitterCode")) {
      Object obj = map.get("submitterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitterCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submitterName")) {
      Object obj = map.get("submitterName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitterName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCause")) {
      Object obj = map.get("payCause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingCode")) {
      Object obj = map.get("procurementStandingCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementStandingCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementStandingName")) {
      Object obj = map.get("procurementStandingName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementStandingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeCode")) {
      Object obj = map.get("payTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeName")) {
      Object obj = map.get("payTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesCode")) {
      Object obj = map.get("projectArchivesCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectArchivesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectArchivesName")) {
      Object obj = map.get("projectArchivesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectArchivesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDueBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acquisitionPhaseCode")) {
      Object obj = map.get("acquisitionPhaseCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAcquisitionPhaseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acquisitionPhaseName")) {
      Object obj = map.get("acquisitionPhaseName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAcquisitionPhaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeCode")) {
      Object obj = map.get("procurementTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementTypeName")) {
      Object obj = map.get("procurementTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayCode")) {
      Object obj = map.get("procurementWayCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementWayCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementWayName")) {
      Object obj = map.get("procurementWayName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementWayName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oneDept")) {
      Object obj = map.get("oneDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOneDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesCode")) {
      Object obj = map.get("procurementPurposesCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementPurposesCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementPurposesName")) {
      Object obj = map.get("procurementPurposesName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcurementPurposesName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
