package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialWriteoffBasicBill extends FinancialBasicBill {


  /**
   * 报销日期
   */
  @TableField("claimDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime claimDate;

  /**
   * 报销部门
   */
  @TableField("claimDept")
  private String claimDept;

  /**
   * 收款银行
   */
  @TableField("dueBank")
  private String dueBank;

  /**
   * 收款账号
   */
  @TableField("accountNumber")
  private String accountNumber;

  /**
   * 收款人
   */
  private String payee;

  /**
   * 报销人所属公司编码
   */
  @TableField("claimCompanyCode")
  private String claimCompanyCode;

  /**
   * 报销人所属公司名称
   */
  @TableField("claimCompanyName")
  private String claimCompanyName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("claimDate", BocpGenUtils.toTimestamp(claimDate));
      map.put("claimDept", claimDept);
      map.put("dueBank", dueBank);
      map.put("accountNumber", accountNumber);
      map.put("payee", payee);
      map.put("claimCompanyCode", claimCompanyCode);
      map.put("claimCompanyName", claimCompanyName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialWriteoffBasicBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialWriteoffBasicBill entity = new FinancialWriteoffBasicBill();
    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("travelReason")) {
      Object obj = map.get("travelReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTravelReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenterCode")) {
      Object obj = map.get("costCenterCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenterName")) {
      Object obj = map.get("costCenterName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCenterName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectAreaCode")) {
      Object obj = map.get("projectAreaCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectAreaname")) {
      Object obj = map.get("projectAreaname");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAreaname((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamName")) {
      Object obj = map.get("kamName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKamName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaderCode")) {
      Object obj = map.get("leaderCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaderName")) {
      Object obj = map.get("leaderName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectTypeCode")) {
      Object obj = map.get("projectTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectTypeName")) {
      Object obj = map.get("projectTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOwnerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectBudgetTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectBudgetTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("staffEmail")) {
      Object obj = map.get("staffEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billTemplate")) {
      Object obj = map.get("billTemplate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("newSupplement")) {
      Object obj = map.get("newSupplement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewSupplement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplementaryApplicationName")) {
      Object obj = map.get("supplementaryApplicationName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplementaryApplicationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplementaryApplicationCode")) {
      Object obj = map.get("supplementaryApplicationCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplementaryApplicationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billTemplateType")) {
      Object obj = map.get("billTemplateType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billsNumber")) {
      Object obj = map.get("billsNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillsNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimDate")) {
      Object obj = map.get("claimDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setClaimDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setClaimDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setClaimDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setClaimDate(null);
      }
    }
    if(map.containsKey("claimDept")) {
      Object obj = map.get("claimDept");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDueBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setClaimCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
