package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 绑定类型
 * </p>
 *
 * @author ultraman
 * @since 2022-08-11
 */
public enum BindTypeEnum {

    BIND("BIND", "绑定"),
    UNBIND("UNBIND", "解绑");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BindTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BindTypeEnum fromCode(String code){
        switch(code) {
            case "BIND":
                return BIND;
            case "UNBIND":
                return UNBIND;
            default:
                return null;
        }
    }
}
