package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目所属区域
 * </p>
 *
 * @author ultraman
 * @since 2022-08-18
 */
public enum ChargeCodeArea {

    _1("1", "华东"),
    _2("2", "华中"),
    _3("3", "北区"),
    _4("4", "南区"),
    _5("5", "光是"),
    _6("6", "数据增值服务、BG筹备组"),
    _7("7", "总部"),
    _8("8", "公司"),
    _10("10", "华东交付部"),
    _11("11", "华东大区KAM部"),
    _12("12", "华北大区KAM部"),
    CODE5("code5", "地产BU"),
    CODE6("code6", "零售 BU"),
    CODE7("code7", "产品部"),
    CODE9("code9", "综合管理部");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeArea(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeArea fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "code5":
                return CODE5;
            case "code6":
                return CODE6;
            case "code7":
                return CODE7;
            case "code9":
                return CODE9;
            default:
                return null;
        }
    }
}
