package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费控佳审批状态
 * </p>
 *
 * @author ultraman
 * @since 2022-08-18
 */
public enum FjkApproveStatusEnum {

    PASS("pass", "审批通过"),
    IN_APPROVE("inApprove", "审批中"),
    RETURN_DIRECT("returnDirect", "退回直送"),
    RETURN_RESET_APPROVE("returnResetApprove", "退回重审"),
    CLOSE("close", "关闭");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FjkApproveStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FjkApproveStatusEnum fromCode(String code){
        switch(code) {
            case "pass":
                return PASS;
            case "inApprove":
                return IN_APPROVE;
            case "returnDirect":
                return RETURN_DIRECT;
            case "returnResetApprove":
                return RETURN_RESET_APPROVE;
            case "close":
                return CLOSE;
            default:
                return null;
        }
    }
}
