package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReceivedPaymentsTaken implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 交易流水号
   */
  @TableField("tradeNo")
  private String tradeNo;

  /**
   * 回款时间
   */
  @TableField("returnedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnedTime;

  /**
   * 回款金额
   */
  @TableField("returnMoney")
  private BigDecimal returnMoney;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 认领状态
   */
  @TableField("takenStatus")
  private String takenStatus;

  /**
   * 已认领金额
   */
  @TableField("takenMoney")
  private BigDecimal takenMoney;

  /**
   * 对方银行账号
   */
  @TableField("customerBankNo")
  private String customerBankNo;

  /**
   * 对方开户机构
   */
  @TableField("openAccountInstitutions")
  private String openAccountInstitutions;

  /**
   * 备注
   */
  private String remark;

  /**
   * 合同签约方名称
   */
  @TableField("contractSignatureName")
  private String contractSignatureName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 订单编号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 对方户名
   */
  @TableField("accountName")
  private String accountName;

  /**
   * 查询方式
   */
  @TableField("searchType")
  private String searchType;

  /**
   * 项目分期名称
   */
  @TableField("projectItemName")
  private String projectItemName;

  /**
   * 项目分期Code
   */
  @TableField("projectItemCode")
  private String projectItemCode;

  /**
   * 回款流水数据来源枚举
   */
  private String channel;

  /**
   * 回执编号
   */
  @TableField("voucherNo")
  private String voucherNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tradeNo", tradeNo);
      map.put("returnedTime", BocpGenUtils.toTimestamp(returnedTime));
      map.put("returnMoney", returnMoney);
      map.put("customerName", customerName);
      map.put("takenStatus", takenStatus);
      map.put("takenMoney", takenMoney);
      map.put("customerBankNo", customerBankNo);
      map.put("openAccountInstitutions", openAccountInstitutions);
      map.put("remark", remark);
      map.put("contractSignatureName", contractSignatureName);
      map.put("contractNo", contractNo);
      map.put("projectName", projectName);
      map.put("orderNo", orderNo);
      map.put("productName", productName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("accountName", accountName);
      map.put("searchType", searchType);
      map.put("projectItemName", projectItemName);
      map.put("projectItemCode", projectItemCode);
      map.put("channel", channel);
      map.put("voucherNo", voucherNo);
      return map;
  }

  public static ReceivedPaymentsTaken fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReceivedPaymentsTaken entity = new ReceivedPaymentsTaken();
    if(map.containsKey("tradeNo")) {
      Object obj = map.get("tradeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnedTime")) {
      Object obj = map.get("returnedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnedTime(null);
      }
    }
    if(map.containsKey("returnMoney")) {
      Object obj = map.get("returnMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReturnMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("takenStatus")) {
      Object obj = map.get("takenStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTakenStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("takenMoney")) {
      Object obj = map.get("takenMoney");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTakenMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTakenMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTakenMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTakenMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTakenMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customerBankNo")) {
      Object obj = map.get("customerBankNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openAccountInstitutions")) {
      Object obj = map.get("openAccountInstitutions");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpenAccountInstitutions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSignatureName")) {
      Object obj = map.get("contractSignatureName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractSignatureName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountName")) {
      Object obj = map.get("accountName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("searchType")) {
      Object obj = map.get("searchType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSearchType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemName")) {
      Object obj = map.get("projectItemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectItemCode")) {
      Object obj = map.get("projectItemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherNo")) {
      Object obj = map.get("voucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucherNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
