package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 项目类别编码
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
public enum ChargeCodeType {

    _1("1", "BU"),
    _2("2", "交付"),
    _3("3", "交付部"),
    _4("4", "产品"),
    _5("5", "人事部"),
    _6("6", "客户"),
    _7("7", "客户服务部"),
    _8("8", "小B运营"),
    _9("9", "总裁办"),
    _10("10", "战略运营中心"),
    _11("11", "数据增值"),
    _12("12", "机会"),
    _13("13", "售前"),
    _14("14", "生态业务筹备组"),
    _15("15", "研发"),
    _16("16", "综合管理"),
    _17("17", "解决方案"),
    _18("18", "财务"),
    _19("19", "销售"),
    _20("20", "培训"),
    _21("21", "休假"),
    _22("22", "空闲"),
    CSM("CSM", "CSM"),
    PE("PE", "商联");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ChargeCodeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeCodeType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "CSM":
                return CSM;
            case "PE":
                return PE;
            default:
                return null;
        }
    }
}
