package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费控佳单据类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
public enum FkjBillTypeEnum {

    PUBLIC_BILL("publicBill", "对公报销单"),
    PUBLIC_PRE_BILL("publicPreBill", "对公预付款申请单"),
    NORMAL_BILL("normalBill", "日常报销单"),
    PUBLIC_CTRIP_BILL("publicCtripBill", "携程对公报销单"),
    OWNER_BILL("ownerBill", "个人借款申请单"),
    TRAVEL_BILL("travelBill", "差旅申请单"),
    BU_THING_PRE_BILL("buThingPreBill", "业务招待事前申请单"),
    BUYER_BILL("buyerBill", "采购申请单"),
    CONTRACT("contract", "通用合同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FkjBillTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FkjBillTypeEnum fromCode(String code){
        switch(code) {
            case "publicBill":
                return PUBLIC_BILL;
            case "publicPreBill":
                return PUBLIC_PRE_BILL;
            case "normalBill":
                return NORMAL_BILL;
            case "publicCtripBill":
                return PUBLIC_CTRIP_BILL;
            case "ownerBill":
                return OWNER_BILL;
            case "travelBill":
                return TRAVEL_BILL;
            case "buThingPreBill":
                return BU_THING_PRE_BILL;
            case "buyerBill":
                return BUYER_BILL;
            case "contract":
                return CONTRACT;
            default:
                return null;
        }
    }
}
