package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费控佳支付方式
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
public enum FkjPayWayEnum {

    BANK("bank", "银行转账"),
    PRE_PAY("prePay", "结转预付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FkjPayWayEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FkjPayWayEnum fromCode(String code){
        switch(code) {
            case "bank":
                return BANK;
            case "prePay":
                return PRE_PAY;
            default:
                return null;
        }
    }
}
