package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialBasicBillDetail;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialTravelApplyBillDetail extends FinancialBasicBillDetail {


  /**
   * 申请人编码
   */
  @TableField("applicantNumber")
  private String applicantNumber;

  /**
   * 申请人名称
   */
  @TableField("applicantName")
  private String applicantName;

  /**
   * 订票人编码
   */
  @TableField("bookerCode")
  private String bookerCode;

  /**
   * 订票人名称
   */
  @TableField("bookerName")
  private String bookerName;

  /**
   * 预定人编码
   */
  @TableField("pssengerCode")
  private String pssengerCode;

  /**
   * 预定人名称
   */
  @TableField("pssengerName")
  private String pssengerName;

  /**
   * 申请日期
   */
  @TableField("applyDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyDate;

  /**
   * 出行日期
   */
  @TableField("tripDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tripDate;

  /**
   * 预估金额
   */
  @TableField("estimatedAmount")
  private String estimatedAmount;

  /**
   * 出行人编码
   */
  @TableField("triperCode")
  private String triperCode;

  /**
   * 出行人名称
   */
  @TableField("triperName")
  private String triperName;

  /**
   * 行程类型
   */
  @TableField("tripType")
  private String tripType;

  /**
   * 出发城市
   */
  @TableField("departCity")
  private String departCity;

  /**
   * 到达城市
   */
  @TableField("destinationCity")
  private String destinationCity;

  /**
   * 出发时间
   */
  @TableField("departTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime departTime;

  /**
   * 达到时间
   */
  @TableField("destinationTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime destinationTime;

  /**
   * 消费内容
   */
  @TableField("contentConsumption")
  private String contentConsumption;

  /**
   * 选择该交通方式的原因
   */
  private String reason;

  /**
   * 用车事由
   */
  @TableField("usedCarCause")
  private String usedCarCause;

  /**
   * 用车城市
   */
  @TableField("usedCarCity")
  private String usedCarCity;

  /**
   * 用车开始日期
   */
  @TableField("usedCarStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime usedCarStartDate;

  /**
   * 用车结束日期
   */
  @TableField("usedCarEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime usedCarEndDate;

  /**
   * 出差开始日期
   */
  @TableField("businessStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessStartDate;

  /**
   * 出差结束日期
   */
  @TableField("businessEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessEndDate;

  /**
   * 消费事由
   */
  @TableField("consumptionCause")
  private String consumptionCause;

  /**
   * 住宿地址
   */
  private String accommodation;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("applicantNumber", applicantNumber);
      map.put("applicantName", applicantName);
      map.put("bookerCode", bookerCode);
      map.put("bookerName", bookerName);
      map.put("pssengerCode", pssengerCode);
      map.put("pssengerName", pssengerName);
      map.put("applyDate", BocpGenUtils.toTimestamp(applyDate));
      map.put("tripDate", BocpGenUtils.toTimestamp(tripDate));
      map.put("estimatedAmount", estimatedAmount);
      map.put("triperCode", triperCode);
      map.put("triperName", triperName);
      map.put("tripType", tripType);
      map.put("departCity", departCity);
      map.put("destinationCity", destinationCity);
      map.put("departTime", BocpGenUtils.toTimestamp(departTime));
      map.put("destinationTime", BocpGenUtils.toTimestamp(destinationTime));
      map.put("contentConsumption", contentConsumption);
      map.put("reason", reason);
      map.put("usedCarCause", usedCarCause);
      map.put("usedCarCity", usedCarCity);
      map.put("usedCarStartDate", BocpGenUtils.toTimestamp(usedCarStartDate));
      map.put("usedCarEndDate", BocpGenUtils.toTimestamp(usedCarEndDate));
      map.put("businessStartDate", BocpGenUtils.toTimestamp(businessStartDate));
      map.put("businessEndDate", BocpGenUtils.toTimestamp(businessEndDate));
      map.put("consumptionCause", consumptionCause);
      map.put("accommodation", accommodation);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static FinancialTravelApplyBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialTravelApplyBillDetail entity = new FinancialTravelApplyBillDetail();
    if(map.containsKey("primaryCostTypeCode")) {
      Object obj = map.get("primaryCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primaryCostTypeName")) {
      Object obj = map.get("primaryCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeCode")) {
      Object obj = map.get("lastCostTypeCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastCostTypeName")) {
      Object obj = map.get("lastCostTypeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastCostTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin")) {
      Object obj = map.get("origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("destination")) {
      Object obj = map.get("destination");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDestination((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tripExplain")) {
      Object obj = map.get("tripExplain");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripExplain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costDate")) {
      Object obj = map.get("costDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCostDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCostDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setCostDate(null);
      }
    }
    if(map.containsKey("billTemplateDetail")) {
      Object obj = map.get("billTemplateDetail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTemplateDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicantNumber")) {
      Object obj = map.get("applicantNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicantName")) {
      Object obj = map.get("applicantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplicantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookerCode")) {
      Object obj = map.get("bookerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookerName")) {
      Object obj = map.get("bookerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pssengerCode")) {
      Object obj = map.get("pssengerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPssengerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pssengerName")) {
      Object obj = map.get("pssengerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPssengerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyDate(null);
      }
    }
    if(map.containsKey("tripDate")) {
      Object obj = map.get("tripDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTripDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTripDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTripDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTripDate(null);
      }
    }
    if(map.containsKey("estimatedAmount")) {
      Object obj = map.get("estimatedAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEstimatedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("triperCode")) {
      Object obj = map.get("triperCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTriperCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("triperName")) {
      Object obj = map.get("triperName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTriperName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tripType")) {
      Object obj = map.get("tripType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTripType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departCity")) {
      Object obj = map.get("departCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("destinationCity")) {
      Object obj = map.get("destinationCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDestinationCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departTime")) {
      Object obj = map.get("departTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDepartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDepartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDepartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDepartTime(null);
      }
    }
    if(map.containsKey("destinationTime")) {
      Object obj = map.get("destinationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDestinationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDestinationTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDestinationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDestinationTime(null);
      }
    }
    if(map.containsKey("contentConsumption")) {
      Object obj = map.get("contentConsumption");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContentConsumption((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usedCarCause")) {
      Object obj = map.get("usedCarCause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usedCarCity")) {
      Object obj = map.get("usedCarCity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUsedCarCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("usedCarStartDate")) {
      Object obj = map.get("usedCarStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsedCarStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUsedCarStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUsedCarStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUsedCarStartDate(null);
      }
    }
    if(map.containsKey("usedCarEndDate")) {
      Object obj = map.get("usedCarEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUsedCarEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUsedCarEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUsedCarEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUsedCarEndDate(null);
      }
    }
    if(map.containsKey("businessStartDate")) {
      Object obj = map.get("businessStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBusinessStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBusinessStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessStartDate(null);
      }
    }
    if(map.containsKey("businessEndDate")) {
      Object obj = map.get("businessEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBusinessEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBusinessEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessEndDate(null);
      }
    }
    if(map.containsKey("consumptionCause")) {
      Object obj = map.get("consumptionCause");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsumptionCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accommodation")) {
      Object obj = map.get("accommodation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccommodation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
