package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SmallBusinessIncome implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 中心客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 签约客户
   */
  @TableField("signCustomerName")
  private String signCustomerName;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * 使用公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 使用公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 标的
   */
  @TableField("targetObject")
  private String targetObject;

  /**
   * 使用月份
   */
  @TableField("useMonth")
  private String useMonth;

  /**
   * 会计期间
   */
  @TableField("chargeMonth")
  private String chargeMonth;

  /**
   * 实际服务开始时间
   */
  @TableField("startDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 预计服务结束时间
   */
  @TableField("predictEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime predictEndDate;

  /**
   * 实际服务结束时间
   */
  @TableField("endDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endDate;

  /**
   *  回款金额 
   */
  @TableField("returnedAmount")
  private BigDecimal returnedAmount;

  /**
   *  当期收入 
   */
  @TableField("currentAmount")
  private BigDecimal currentAmount;

  /**
   * 订单id
   */
  @TableField("orderId")
  private Long orderId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 产品税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   *  当期含税收入
   */
  @TableField("currentAmountWithTax")
  private BigDecimal currentAmountWithTax;

  /**
   * 每月有效计费天数
   */
  @TableField("validDays")
  private Long validDays;

  /**
   * 日单价
   */
  @TableField("dayPrice")
  private BigDecimal dayPrice;

  /**
   * 来源
   */
  private String source;

  /**
   * 使用开始日期
   */
  @TableField("useStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime useStartDate;

  /**
   * 使用结束日期
   */
  @TableField("useEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime useEndDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("customerName", customerName);
      map.put("contractNo", contractNo);
      map.put("signCustomerName", signCustomerName);
      map.put("projectName", projectName);
      map.put("companyName", companyName);
      map.put("companyTaxNo", companyTaxNo);
      map.put("targetObject", targetObject);
      map.put("useMonth", useMonth);
      map.put("chargeMonth", chargeMonth);
      map.put("startDate", BocpGenUtils.toTimestamp(startDate));
      map.put("predictEndDate", BocpGenUtils.toTimestamp(predictEndDate));
      map.put("endDate", BocpGenUtils.toTimestamp(endDate));
      map.put("returnedAmount", returnedAmount);
      map.put("currentAmount", currentAmount);
      map.put("orderId", orderId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("taxRate", taxRate);
      map.put("currentAmountWithTax", currentAmountWithTax);
      map.put("validDays", validDays);
      map.put("dayPrice", dayPrice);
      map.put("source", source);
      map.put("useStartDate", BocpGenUtils.toTimestamp(useStartDate));
      map.put("useEndDate", BocpGenUtils.toTimestamp(useEndDate));
      return map;
  }

  public static SmallBusinessIncome fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SmallBusinessIncome entity = new SmallBusinessIncome();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signCustomerName")) {
      Object obj = map.get("signCustomerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetObject")) {
      Object obj = map.get("targetObject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTargetObject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useMonth")) {
      Object obj = map.get("useMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeMonth")) {
      Object obj = map.get("chargeMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("startDate")) {
      Object obj = map.get("startDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("predictEndDate")) {
      Object obj = map.get("predictEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPredictEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPredictEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPredictEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPredictEndDate(null);
      }
    }
    if(map.containsKey("endDate")) {
      Object obj = map.get("endDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndDate(null);
      }
    }
    if(map.containsKey("returnedAmount")) {
      Object obj = map.get("returnedAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReturnedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmount")) {
      Object obj = map.get("currentAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currentAmountWithTax")) {
      Object obj = map.get("currentAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("validDays")) {
      Object obj = map.get("validDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setValidDays((Long)obj);
        } else if(obj instanceof String) {
          entity.setValidDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setValidDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dayPrice")) {
      Object obj = map.get("dayPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDayPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDayPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDayPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDayPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDayPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useStartDate")) {
      Object obj = map.get("useStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUseStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUseStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUseStartDate(null);
      }
    }
    if(map.containsKey("useEndDate")) {
      Object obj = map.get("useEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUseEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUseEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUseEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUseEndDate(null);
      }
    }
    return entity;
  }
}
