package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SmallOrderInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 商品内容
   */
  private String content;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 公司税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 中心租户名称
   */
  @TableField("centerTenantName")
  private String centerTenantName;

  /**
   * 中心租户id
   */
  @TableField("centerTenantId")
  private String centerTenantId;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 下单方式
   */
  @TableField("orderWay")
  private String orderWay;

  /**
   * 合同状态
   */
  @TableField("contractStatus")
  private String contractStatus;

  /**
   * 订单总金额含税
   */
  @TableField("totalAmountWithTax")
  private BigDecimal totalAmountWithTax;

  /**
   * 应付金额含税
   */
  @TableField("platAmountWithTax")
  private BigDecimal platAmountWithTax;

  /**
   * 折扣金额
   */
  @TableField("discountAmount")
  private BigDecimal discountAmount;

  /**
   * 支付方式
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 订单创建时间
   */
  @TableField("generalTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime generalTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 支付时间
   */
  @TableField("paymentTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentTime;

  /**
   * 服务开通时间
   */
  @TableField("serviceOpenTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceOpenTime;

  /**
   * 服务预计结束时间
   */
  @TableField("preServiceCloseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime preServiceCloseTime;

  /**
   * 实际服务结束时间
   */
  @TableField("realServiceCloseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime realServiceCloseTime;

  /**
   * 回款金额
   */
  @TableField("payBackAmount")
  private BigDecimal payBackAmount;

  /**
   * 激活状态
   */
  @TableField("activateStatus")
  private String activateStatus;

  /**
   * 标的
   */
  @TableField("subjectMatter")
  private String subjectMatter;

  /**
   * 汇款码
   */
  @TableField("remittanceNo")
  private String remittanceNo;

  /**
   * 账单id
   */
  @TableField("invoiceRecordId")
  private String invoiceRecordId;

  /**
   * 商品内容Code
   */
  @TableField("packageCode")
  private String packageCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("content", content);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("centerTenantName", centerTenantName);
      map.put("centerTenantId", centerTenantId);
      map.put("orderStatus", orderStatus);
      map.put("orderType", orderType);
      map.put("orderWay", orderWay);
      map.put("contractStatus", contractStatus);
      map.put("totalAmountWithTax", totalAmountWithTax);
      map.put("platAmountWithTax", platAmountWithTax);
      map.put("discountAmount", discountAmount);
      map.put("paymentType", paymentType);
      map.put("generalTime", BocpGenUtils.toTimestamp(generalTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("paymentTime", BocpGenUtils.toTimestamp(paymentTime));
      map.put("serviceOpenTime", BocpGenUtils.toTimestamp(serviceOpenTime));
      map.put("preServiceCloseTime", BocpGenUtils.toTimestamp(preServiceCloseTime));
      map.put("realServiceCloseTime", BocpGenUtils.toTimestamp(realServiceCloseTime));
      map.put("payBackAmount", payBackAmount);
      map.put("activateStatus", activateStatus);
      map.put("subjectMatter", subjectMatter);
      map.put("remittanceNo", remittanceNo);
      map.put("invoiceRecordId", invoiceRecordId);
      map.put("packageCode", packageCode);
      return map;
  }

  public static SmallOrderInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SmallOrderInfo entity = new SmallOrderInfo();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("content")) {
      Object obj = map.get("content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("centerTenantName")) {
      Object obj = map.get("centerTenantName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCenterTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("centerTenantId")) {
      Object obj = map.get("centerTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCenterTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderWay")) {
      Object obj = map.get("orderWay");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractStatus")) {
      Object obj = map.get("contractStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmountWithTax")) {
      Object obj = map.get("totalAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platAmountWithTax")) {
      Object obj = map.get("platAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPlatAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmount")) {
      Object obj = map.get("discountAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generalTime")) {
      Object obj = map.get("generalTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGeneralTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGeneralTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGeneralTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGeneralTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentTime")) {
      Object obj = map.get("paymentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentTime(null);
      }
    }
    if(map.containsKey("serviceOpenTime")) {
      Object obj = map.get("serviceOpenTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setServiceOpenTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setServiceOpenTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceOpenTime(null);
      }
    }
    if(map.containsKey("preServiceCloseTime")) {
      Object obj = map.get("preServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPreServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPreServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPreServiceCloseTime(null);
      }
    }
    if(map.containsKey("realServiceCloseTime")) {
      Object obj = map.get("realServiceCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRealServiceCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRealServiceCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRealServiceCloseTime(null);
      }
    }
    if(map.containsKey("payBackAmount")) {
      Object obj = map.get("payBackAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("activateStatus")) {
      Object obj = map.get("activateStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActivateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subjectMatter")) {
      Object obj = map.get("subjectMatter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectMatter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remittanceNo")) {
      Object obj = map.get("remittanceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemittanceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceRecordId")) {
      Object obj = map.get("invoiceRecordId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceRecordId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageCode")) {
      Object obj = map.get("packageCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPackageCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
