package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 合同明细
 * </p>
 *
 * @author ultraman
 * @since 2022-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ContractDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 数量
   */
  private BigDecimal amount;

  /**
   * 单价(不含税)
   */
  @TableField("unitPrice")
  private BigDecimal unitPrice;

  /**
   * 结算条件
   */
  @TableField("chargeRequirement")
  private String chargeRequirement;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 付费方式
   */
  @TableField("chargeType")
  private String chargeType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 是否有效
   */
  private String validation;

  /**
   * 数量
   */
  private String quantity;

  /**
   * 单价(不含税)
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 付款条件
   */
  @TableField("paymentRequirement")
  private String paymentRequirement;

  /**
   * 付款比例
   */
  @TableField("paymentPercent")
  private BigDecimal paymentPercent;

  /**
   * 是否有质保金
   */
  @TableField("containsRetentionMoney")
  private String containsRetentionMoney;

  /**
   * 验收报告签署日期
   */
  @TableField("receiptSignDateStr")
  private String receiptSignDateStr;

  /**
   * 是否首次付款条件
   */
  @TableField("firstPayRequirementOrNot")
  private String firstPayRequirementOrNot;

  /**
   * 结算周期
   */
  @TableField("chargeCycle")
  private String chargeCycle;

  /**
   * 计费类型
   */
  @TableField("billingType")
  private String billingType;

  /**
   * N等于
   */
  private String days;

  /**
   * 是否外包
   */
  private Boolean outsourcing;

  /**
   * 关联采购合同
   */
  @TableField("linkedPurchaseContractNo")
  private String linkedPurchaseContractNo;

  /**
   * 计费规则
   */
  @TableField("chargeRules")
  private String chargeRules;

  /**
   * 产品状态
   */
  @TableField("productStatus")
  private String productStatus;

  /**
   * 产品验收状态
   */
  @TableField("productAcceptanceStatus")
  private String productAcceptanceStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("contractNo", contractNo);
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("amount", amount);
      map.put("unitPrice", unitPrice);
      map.put("chargeRequirement", chargeRequirement);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("chargeType", chargeType);
      map.put("taxRate", taxRate);
      map.put("validation", validation);
      map.put("quantity", quantity);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("paymentRequirement", paymentRequirement);
      map.put("paymentPercent", paymentPercent);
      map.put("containsRetentionMoney", containsRetentionMoney);
      map.put("receiptSignDateStr", receiptSignDateStr);
      map.put("firstPayRequirementOrNot", firstPayRequirementOrNot);
      map.put("chargeCycle", chargeCycle);
      map.put("billingType", billingType);
      map.put("days", days);
      map.put("outsourcing", outsourcing);
      map.put("linkedPurchaseContractNo", linkedPurchaseContractNo);
      map.put("chargeRules", chargeRules);
      map.put("productStatus", productStatus);
      map.put("productAcceptanceStatus", productAcceptanceStatus);
      return map;
  }

  public static ContractDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ContractDetail entity = new ContractDetail();
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("chargeRequirement")) {
      Object obj = map.get("chargeRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("validation")) {
      Object obj = map.get("validation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setValidation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentRequirement((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainsRetentionMoney((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptSignDateStr")) {
      Object obj = map.get("receiptSignDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiptSignDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstPayRequirementOrNot")) {
      Object obj = map.get("firstPayRequirementOrNot");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFirstPayRequirementOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("days")) {
      Object obj = map.get("days");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDays((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outsourcing")) {
      Object obj = map.get("outsourcing");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setOutsourcing((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setOutsourcing(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("linkedPurchaseContractNo")) {
      Object obj = map.get("linkedPurchaseContractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLinkedPurchaseContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeRules")) {
      Object obj = map.get("chargeRules");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productStatus")) {
      Object obj = map.get("productStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productAcceptanceStatus")) {
      Object obj = map.get("productAcceptanceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductAcceptanceStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("chargeRequirement")) {
      Object obj = map.get("chargeRequirement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeRequirement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeType")) {
      Object obj = map.get("chargeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("validation")) {
      Object obj = map.get("validation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paymentRequirement")) {
      Object obj = map.get("paymentRequirement");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentRequirement((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentPercent")) {
      Object obj = map.get("paymentPercent");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaymentPercent((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaymentPercent(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaymentPercent(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPaymentPercent(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaymentPercent(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("containsRetentionMoney")) {
      Object obj = map.get("containsRetentionMoney");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContainsRetentionMoney((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiptSignDateStr")) {
      Object obj = map.get("receiptSignDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptSignDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstPayRequirementOrNot")) {
      Object obj = map.get("firstPayRequirementOrNot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFirstPayRequirementOrNot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeCycle")) {
      Object obj = map.get("chargeCycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingType")) {
      Object obj = map.get("billingType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("days")) {
      Object obj = map.get("days");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDays((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outsourcing")) {
      Object obj = map.get("outsourcing");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setOutsourcing((Boolean)obj);
        } else if(obj instanceof String) {
          this.setOutsourcing(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("linkedPurchaseContractNo")) {
      Object obj = map.get("linkedPurchaseContractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLinkedPurchaseContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeRules")) {
      Object obj = map.get("chargeRules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productStatus")) {
      Object obj = map.get("productStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productAcceptanceStatus")) {
      Object obj = map.get("productAcceptanceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductAcceptanceStatus((String)obj);
        }
      } else {
      }
    }
  }
}
