package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FkjBillInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据编号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 单据主题
   */
  @TableField("billSubject")
  private String billSubject;

  /**
   * 单据类型
   */
  @TableField("billType")
  private String billType;

  /**
   * 申请人员工号
   */
  @TableField("applyUserNo")
  private String applyUserNo;

  /**
   * 申请人姓名
   */
  @TableField("applyUserName")
  private String applyUserName;

  /**
   * 部门编码
   */
  @TableField("departMentCode")
  private String departMentCode;

  /**
   * 部门名称(分摊)
   */
  @TableField("departMentName")
  private String departMentName;

  /**
   * 公司编码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 活动编码
   */
  @TableField("activityCode")
  private String activityCode;

  /**
   * 活动名称
   */
  @TableField("activityName")
  private String activityName;

  /**
   * 产品编码
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 支付方式
   */
  @TableField("payWay")
  private String payWay;

  /**
   * 审批状态
   */
  @TableField("approveStatus")
  private String approveStatus;

  /**
   * 最后审批人
   */
  @TableField("lastApproveUserName")
  private String lastApproveUserName;

  /**
   * 项目编号
   */
  @TableField("projectNo")
  private String projectNo;

  /**
   * 项目名称
   */
  @TableField("projectName")
  private String projectName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 供应商
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 申请金额
   */
  @TableField("supplyAmount")
  private BigDecimal supplyAmount;

  /**
   * 费用类别
   */
  @TableField("expensesType")
  private String expensesType;

  /**
   * 是否超政策
   */
  @TableField("overPolicy")
  private Boolean overPolicy;

  /**
   * 是否超预算
   */
  @TableField("overBudget")
  private Boolean overBudget;

  /**
   * 备注
   */
  private String remark;

  /**
   * 影像数量
   */
  @TableField("imageNum")
  private Long imageNum;

  /**
   * 事前申请单号
   */
  @TableField("thingBeforeApproveBillNo")
  private String thingBeforeApproveBillNo;

  /**
   * 影像附件地址
   */
  @TableField("imageUrls")
  private String imageUrls;

  /**
   * 审批开始时间
   */
  @TableField("approvePassStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvePassStartDate;

  /**
   * 审批结束时间
   */
  @TableField("approvePassEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvePassEndDate;

  /**
   * 审批通过时间
   */
  @TableField("impApprovePassDateStr")
  private String impApprovePassDateStr;

  /**
   * 面单图像数量
   */
  @TableField("faceImageNum")
  private Long faceImageNum;

  /**
   * 面单图像地址
   */
  @TableField("factImageUrls")
  private String factImageUrls;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("billSubject", billSubject);
      map.put("billType", billType);
      map.put("applyUserNo", applyUserNo);
      map.put("applyUserName", applyUserName);
      map.put("departMentCode", departMentCode);
      map.put("departMentName", departMentName);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("activityCode", activityCode);
      map.put("activityName", activityName);
      map.put("productCode", productCode);
      map.put("productName", productName);
      map.put("payWay", payWay);
      map.put("approveStatus", approveStatus);
      map.put("lastApproveUserName", lastApproveUserName);
      map.put("projectNo", projectNo);
      map.put("projectName", projectName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("supplierName", supplierName);
      map.put("supplyAmount", supplyAmount);
      map.put("expensesType", expensesType);
      map.put("overPolicy", overPolicy);
      map.put("overBudget", overBudget);
      map.put("remark", remark);
      map.put("imageNum", imageNum);
      map.put("thingBeforeApproveBillNo", thingBeforeApproveBillNo);
      map.put("imageUrls", imageUrls);
      map.put("approvePassStartDate", BocpGenUtils.toTimestamp(approvePassStartDate));
      map.put("approvePassEndDate", BocpGenUtils.toTimestamp(approvePassEndDate));
      map.put("impApprovePassDateStr", impApprovePassDateStr);
      map.put("faceImageNum", faceImageNum);
      map.put("factImageUrls", factImageUrls);
      return map;
  }

  public static FkjBillInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FkjBillInfo entity = new FkjBillInfo();
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billSubject")) {
      Object obj = map.get("billSubject");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserNo")) {
      Object obj = map.get("applyUserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyUserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departMentCode")) {
      Object obj = map.get("departMentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartMentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departMentName")) {
      Object obj = map.get("departMentName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartMentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activityCode")) {
      Object obj = map.get("activityCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActivityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activityName")) {
      Object obj = map.get("activityName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setActivityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payWay")) {
      Object obj = map.get("payWay");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveStatus")) {
      Object obj = map.get("approveStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApproveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastApproveUserName")) {
      Object obj = map.get("lastApproveUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLastApproveUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplyAmount")) {
      Object obj = map.get("supplyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSupplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSupplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSupplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSupplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSupplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("expensesType")) {
      Object obj = map.get("expensesType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpensesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("overPolicy")) {
      Object obj = map.get("overPolicy");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setOverPolicy((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setOverPolicy(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("overBudget")) {
      Object obj = map.get("overBudget");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setOverBudget((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setOverBudget(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageNum")) {
      Object obj = map.get("imageNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setImageNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("thingBeforeApproveBillNo")) {
      Object obj = map.get("thingBeforeApproveBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThingBeforeApproveBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageUrls")) {
      Object obj = map.get("imageUrls");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImageUrls((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approvePassStartDate")) {
      Object obj = map.get("approvePassStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovePassStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApprovePassStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovePassStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovePassStartDate(null);
      }
    }
    if(map.containsKey("approvePassEndDate")) {
      Object obj = map.get("approvePassEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovePassEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApprovePassEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovePassEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovePassEndDate(null);
      }
    }
    if(map.containsKey("impApprovePassDateStr")) {
      Object obj = map.get("impApprovePassDateStr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImpApprovePassDateStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("faceImageNum")) {
      Object obj = map.get("faceImageNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFaceImageNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setFaceImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFaceImageNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("factImageUrls")) {
      Object obj = map.get("factImageUrls");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFactImageUrls((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billSubject")) {
      Object obj = map.get("billSubject");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillSubject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billType")) {
      Object obj = map.get("billType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserNo")) {
      Object obj = map.get("applyUserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserName")) {
      Object obj = map.get("applyUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departMentCode")) {
      Object obj = map.get("departMentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartMentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departMentName")) {
      Object obj = map.get("departMentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartMentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("activityCode")) {
      Object obj = map.get("activityCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("activityName")) {
      Object obj = map.get("activityName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivityName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payWay")) {
      Object obj = map.get("payWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approveStatus")) {
      Object obj = map.get("approveStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApproveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastApproveUserName")) {
      Object obj = map.get("lastApproveUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastApproveUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectNo")) {
      Object obj = map.get("projectNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectName")) {
      Object obj = map.get("projectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplyAmount")) {
      Object obj = map.get("supplyAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSupplyAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSupplyAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSupplyAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSupplyAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSupplyAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("expensesType")) {
      Object obj = map.get("expensesType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpensesType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("overPolicy")) {
      Object obj = map.get("overPolicy");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setOverPolicy((Boolean)obj);
        } else if(obj instanceof String) {
          this.setOverPolicy(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("overBudget")) {
      Object obj = map.get("overBudget");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setOverBudget((Boolean)obj);
        } else if(obj instanceof String) {
          this.setOverBudget(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imageNum")) {
      Object obj = map.get("imageNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setImageNum((Long)obj);
        } else if(obj instanceof String) {
          this.setImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setImageNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("thingBeforeApproveBillNo")) {
      Object obj = map.get("thingBeforeApproveBillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThingBeforeApproveBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imageUrls")) {
      Object obj = map.get("imageUrls");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImageUrls((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approvePassStartDate")) {
      Object obj = map.get("approvePassStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApprovePassStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApprovePassStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setApprovePassStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApprovePassStartDate(null);
      }
    }
    if(map.containsKey("approvePassEndDate")) {
      Object obj = map.get("approvePassEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApprovePassEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApprovePassEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setApprovePassEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApprovePassEndDate(null);
      }
    }
    if(map.containsKey("impApprovePassDateStr")) {
      Object obj = map.get("impApprovePassDateStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImpApprovePassDateStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("faceImageNum")) {
      Object obj = map.get("faceImageNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFaceImageNum((Long)obj);
        } else if(obj instanceof String) {
          this.setFaceImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setFaceImageNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("factImageUrls")) {
      Object obj = map.get("factImageUrls");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactImageUrls((String)obj);
        }
      } else {
      }
    }
  }
}
