package com.xforceplus.financialsettlement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 服务成本明细
 * </p>
 *
 * @author ultraman
 * @since 2022-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ServiceCostDetails implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 服务名称
   */
  private String serviceName;

  /**
   * 服务编码
   */
  private String serviceCode;

  /**
   * 成本编码
   */
  private String costCode;

  /**
   * 产品阶段
   */
  private String productPhase;

  /**
   * 成本类型
   */
  private String costType;

  /**
   * 成本归属
   */
  private String costBelong;

  /**
   * 数据来源
   */
  private String dataSource;

  /**
   * 发生时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime occurencyTime;

  /**
   * 部门名称
   */
  private String departmentName;

  /**
   * 部门编码
   */
  private String departmentCode;

  /**
   * 分摊流水号
   */
  private String divideCode;

  /**
   * 提交状态
   */
  private String submitStatus;

  /**
   * 累计费用
   */
  private BigDecimal cumulativeCost;

  /**
   * 当期费用
   */
  private BigDecimal currentCost;

  /**
   * 累计用量
   */
  private BigDecimal cumulativeOutput;

  /**
   * 当期用量
   */
  private BigDecimal currentOutput;

  /**
   * 单价
   */
  private BigDecimal unitPrice;

  /**
   * 成本名称
   */
  private String costName;

  /**
   * 主信息编码
   */
  private String parentChargecode;

  /**
   * 会计年度
   */
  private Long accountingYear;

  /**
   * 会计期间
   */
  private Long accountingMonth;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("service_name", serviceName);
      map.put("service_code", serviceCode);
      map.put("cost_code", costCode);
      map.put("product_phase", productPhase);
      map.put("cost_type", costType);
      map.put("cost_belong", costBelong);
      map.put("data_source", dataSource);
      map.put("occurency_time", BocpGenUtils.toTimestamp(occurencyTime));
      map.put("department_name", departmentName);
      map.put("department_code", departmentCode);
      map.put("divide_code", divideCode);
      map.put("submit_status", submitStatus);
      map.put("cumulative_cost", cumulativeCost);
      map.put("current_cost", currentCost);
      map.put("cumulative_output", cumulativeOutput);
      map.put("current_output", currentOutput);
      map.put("unit_price", unitPrice);
      map.put("cost_name", costName);
      map.put("parent_chargecode", parentChargecode);
      map.put("accounting_year", accountingYear);
      map.put("accounting_month", accountingMonth);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ServiceCostDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ServiceCostDetails entity = new ServiceCostDetails();
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_code")) {
      Object obj = map.get("service_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setServiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_phase")) {
      Object obj = map.get("product_phase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductPhase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_type")) {
      Object obj = map.get("cost_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_source")) {
      Object obj = map.get("data_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("occurency_time")) {
      Object obj = map.get("occurency_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOccurencyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOccurencyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOccurencyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOccurencyTime(null);
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_code")) {
      Object obj = map.get("department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("divide_code")) {
      Object obj = map.get("divide_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDivideCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cumulative_cost")) {
      Object obj = map.get("cumulative_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCumulativeCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCumulativeCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCumulativeCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCumulativeCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCumulativeCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_cost")) {
      Object obj = map.get("current_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cumulative_output")) {
      Object obj = map.get("cumulative_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCumulativeOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCumulativeOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCumulativeOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCumulativeOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCumulativeOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_output")) {
      Object obj = map.get("current_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCurrentOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cost_name")) {
      Object obj = map.get("cost_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_chargecode")) {
      Object obj = map.get("parent_chargecode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentChargecode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_year")) {
      Object obj = map.get("accounting_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountingYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("accounting_month")) {
      Object obj = map.get("accounting_month");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountingMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("service_code")) {
      Object obj = map.get("service_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_phase")) {
      Object obj = map.get("product_phase");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductPhase((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cost_type")) {
      Object obj = map.get("cost_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostBelong((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_source")) {
      Object obj = map.get("data_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("occurency_time")) {
      Object obj = map.get("occurency_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOccurencyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOccurencyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setOccurencyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOccurencyTime(null);
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("department_code")) {
      Object obj = map.get("department_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("divide_code")) {
      Object obj = map.get("divide_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDivideCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubmitStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cumulative_cost")) {
      Object obj = map.get("cumulative_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCumulativeCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCumulativeCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCumulativeCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setCumulativeCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCumulativeCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("current_cost")) {
      Object obj = map.get("current_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setCurrentCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cumulative_output")) {
      Object obj = map.get("cumulative_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCumulativeOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCumulativeOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCumulativeOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setCumulativeOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCumulativeOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("current_output")) {
      Object obj = map.get("current_output");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentOutput((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentOutput(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentOutput(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setCurrentOutput(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentOutput(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cost_name")) {
      Object obj = map.get("cost_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parent_chargecode")) {
      Object obj = map.get("parent_chargecode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParentChargecode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accounting_year")) {
      Object obj = map.get("accounting_year");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingYear((Long)obj);
        } else if(obj instanceof String) {
          this.setAccountingYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountingYear(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("accounting_month")) {
      Object obj = map.get("accounting_month");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAccountingMonth((Long)obj);
        } else if(obj instanceof String) {
          this.setAccountingMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountingMonth(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
