package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialWriteoffBasicBill;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialInvoicePledgeBill extends FinancialWriteoffBasicBill {


  /**
   * 采购事项单据单号
   */
  @TableField("procurementDocumentsNo")
  private String procurementDocumentsNo;

  /**
   * 采购事项单据标题
   */
  @TableField("procurementDocumentsTitle")
  private String procurementDocumentsTitle;

  /**
   * 核票责任人编码
   */
  @TableField("responsibleCode")
  private String responsibleCode;

  /**
   * 核票责任人名称
   */
  @TableField("responsibleName")
  private String responsibleName;

  /**
   * 押金追回责任人编码
   */
  @TableField("replevinCode")
  private String replevinCode;

  /**
   * 押金追回责任人名称
   */
  @TableField("replevinName")
  private String replevinName;

  /**
   * 申请人部门
   */
  @TableField("applicationDept")
  private String applicationDept;

  /**
   * 事由
   */
  private String cause;

  /**
   * 供应商编码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 核销类型编码
   */
  @TableField("verificationTypeCode")
  private String verificationTypeCode;

  /**
   * 核销类型名称
   */
  @TableField("verificationTypeName")
  private String verificationTypeName;

  /**
   * 付款主体编码
   */
  @TableField("paymentCode")
  private String paymentCode;

  /**
   * 付款主体名称
   */
  @TableField("paymentName")
  private String paymentName;

  /**
   * 签约主体
   */
  @TableField("contractParty")
  private String contractParty;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("procurementDocumentsNo", procurementDocumentsNo);
      map.put("procurementDocumentsTitle", procurementDocumentsTitle);
      map.put("responsibleCode", responsibleCode);
      map.put("responsibleName", responsibleName);
      map.put("replevinCode", replevinCode);
      map.put("replevinName", replevinName);
      map.put("applicationDept", applicationDept);
      map.put("cause", cause);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("verificationTypeCode", verificationTypeCode);
      map.put("verificationTypeName", verificationTypeName);
      map.put("paymentCode", paymentCode);
      map.put("paymentName", paymentName);
      map.put("contractParty", contractParty);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialInvoicePledgeBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialInvoicePledgeBill entity = new FinancialInvoicePledgeBill();
    entity.setParentByOQSMap(map);
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementDocumentsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleCode")) {
      Object obj = map.get("responsibleCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResponsibleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responsibleName")) {
      Object obj = map.get("responsibleName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResponsibleName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replevinCode")) {
      Object obj = map.get("replevinCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplevinCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("replevinName")) {
      Object obj = map.get("replevinName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReplevinName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationDept((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verificationTypeCode")) {
      Object obj = map.get("verificationTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerificationTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verificationTypeName")) {
      Object obj = map.get("verificationTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerificationTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("procurementDocumentsNo")) {
      Object obj = map.get("procurementDocumentsNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementDocumentsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementDocumentsTitle")) {
      Object obj = map.get("procurementDocumentsTitle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementDocumentsTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("responsibleCode")) {
      Object obj = map.get("responsibleCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResponsibleCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("responsibleName")) {
      Object obj = map.get("responsibleName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResponsibleName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("replevinCode")) {
      Object obj = map.get("replevinCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplevinCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("replevinName")) {
      Object obj = map.get("replevinName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReplevinName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applicationDept")) {
      Object obj = map.get("applicationDept");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplicationDept((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCause((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verificationTypeCode")) {
      Object obj = map.get("verificationTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerificationTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verificationTypeName")) {
      Object obj = map.get("verificationTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerificationTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentCode")) {
      Object obj = map.get("paymentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentName")) {
      Object obj = map.get("paymentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractParty")) {
      Object obj = map.get("contractParty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractParty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
