package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * financifal_budget_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-21
 */
public enum FinancifalBudgetType {

    _1("1", "项目管理人工成本"),
    _2("2", "项目管理差旅预算"),
    _3("3", "项目管理客情预算"),
    _4("4", "交付实施人工成本"),
    _5("5", "交付实施差旅预算"),
    _6("6", "运维预算"),
    _7("7", "超级/高级支持服务预算"),
    _8("8", "交付实施客情预算");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FinancifalBudgetType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FinancifalBudgetType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
