package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * not_taken_channel_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-11-21
 */
public enum NotTakenChannelEnum {

    IMPORT("import", "文件导入"),
    NBCB("nbcb", "宁波银行");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NotTakenChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NotTakenChannelEnum fromCode(String code){
        switch(code) {
            case "import":
                return IMPORT;
            case "nbcb":
                return NBCB;
            default:
                return null;
        }
    }
}
