package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-21
 */
public enum PayType {

    NEW_BUY("NEW_BUY", "新购"),
    RECHARGE("RECHARGE", "续费"),
    BACK("BACK", "补缴"),
    UPGRADE("UPGRADE", "升级");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayType fromCode(String code){
        switch(code) {
            case "NEW_BUY":
                return NEW_BUY;
            case "RECHARGE":
                return RECHARGE;
            case "BACK":
                return BACK;
            case "UPGRADE":
                return UPGRADE;
            default:
                return null;
        }
    }
}
