package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * charegeCode基础信息
 * </p>
 *
 * @author ultraman
 * @since 2023-11-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodePool implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * Chargecode编号
   */
  @TableField("ccCode")
  private String ccCode;

  /**
   * Chargecode描述
   */
  @TableField("ccName")
  private String ccName;

  /**
   * Chargecode类型
   */
  @TableField("ccType")
  private String ccType;

  /**
   * 关联Chargecode
   */
  @TableField("relationCodes")
  private String relationCodes;

  /**
   * 大区名称
   */
  private String district;

  /**
   * 经营单元
   */
  @TableField("bizUnit")
  private String bizUnit;

  /**
   * 状态
   */
  @TableField("ccStatus")
  private String ccStatus;

  /**
   * 扩展标签
   */
  @TableField("extensionTag")
  private String extensionTag;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 销售
   */
  private String kam;

  /**
   * Chargecode负责人工号
   */
  @TableField("ownerCode")
  private String ownerCode;

  /**
   * Chargecode负责人
   */
  @TableField("ownerName")
  private String ownerName;

  /**
   * 负责人直属领导人工号
   */
  @TableField("primaryLeaderCode")
  private String primaryLeaderCode;

  /**
   * 负责人直属领导
   */
  @TableField("primaryLeaderName")
  private String primaryLeaderName;

  /**
   * 类型code
   */
  @TableField("ccTypeCode")
  private String ccTypeCode;

  /**
   * 大区code
   */
  @TableField("districtCode")
  private String districtCode;

  /**
   * 经营单元(组织架构的部门)
   */
  @TableField("bizUnitCode")
  private String bizUnitCode;

  /**
   * 销售工号
   */
  @TableField("kamCode")
  private String kamCode;

  /**
   * 一级部门负责人工号
   */
  @TableField("levelOneDepartmentCode")
  private String levelOneDepartmentCode;

  /**
   * 一级部门负责人工号名称
   */
  @TableField("levelOneDepartmentName")
  private String levelOneDepartmentName;

  /**
   * 批次号
   */
  @TableField("requestId")
  private String requestId;

  /**
   * 推送时间
   */
  @TableField("pushTime")
  private String pushTime;

  /**
   * 创建用户Id
   */
  @TableField("ccCreateUserId")
  private Long ccCreateUserId;

  /**
   * 创建用户名称
   */
  @TableField("ccCreateUserName")
  private String ccCreateUserName;

  /**
   * 更新用户Id
   */
  @TableField("ccUpdateUserId")
  private Long ccUpdateUserId;

  /**
   * 更换用户名称
   */
  @TableField("ccUpdateUserName")
  private String ccUpdateUserName;

  /**
   * 基础数据入库时间-pms系统
   */
  @TableField("insertTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime insertTime;

  /**
   * 部门名称
   */
  @TableField("departmentName")
  private String departmentName;

  /**
   * 关联滴滴id
   */
  @TableField("ddId")
  private String ddId;

  /**
   * 失效的数据推送至易快报
   */
  @TableField("invalidPushStatusYkb")
  private String invalidPushStatusYkb;

  /**
   * 失效时间
   */
  @TableField("invalidDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invalidDate;

  /**
   * 易快报父级Code
   */
  @TableField("ykbParentCode")
  private String ykbParentCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ccCode", ccCode);
      map.put("ccName", ccName);
      map.put("ccType", ccType);
      map.put("relationCodes", relationCodes);
      map.put("district", district);
      map.put("bizUnit", bizUnit);
      map.put("ccStatus", ccStatus);
      map.put("extensionTag", extensionTag);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("kam", kam);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("primaryLeaderCode", primaryLeaderCode);
      map.put("primaryLeaderName", primaryLeaderName);
      map.put("ccTypeCode", ccTypeCode);
      map.put("districtCode", districtCode);
      map.put("bizUnitCode", bizUnitCode);
      map.put("kamCode", kamCode);
      map.put("levelOneDepartmentCode", levelOneDepartmentCode);
      map.put("levelOneDepartmentName", levelOneDepartmentName);
      map.put("requestId", requestId);
      map.put("pushTime", pushTime);
      map.put("ccCreateUserId", ccCreateUserId);
      map.put("ccCreateUserName", ccCreateUserName);
      map.put("ccUpdateUserId", ccUpdateUserId);
      map.put("ccUpdateUserName", ccUpdateUserName);
      map.put("insertTime", BocpGenUtils.toTimestamp(insertTime));
      map.put("departmentName", departmentName);
      map.put("ddId", ddId);
      map.put("invalidPushStatusYkb", invalidPushStatusYkb);
      map.put("invalidDate", BocpGenUtils.toTimestamp(invalidDate));
      map.put("ykbParentCode", ykbParentCode);

      return map;
  }

  public static ChargeCodePool fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodePool entity = new ChargeCodePool();
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("relationCodes")) {
      Object obj = map.get("relationCodes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelationCodes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizUnit")) {
      Object obj = map.get("bizUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccStatus")) {
      Object obj = map.get("ccStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extensionTag")) {
      Object obj = map.get("extensionTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtensionTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kam")) {
      Object obj = map.get("kam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primaryLeaderCode")) {
      Object obj = map.get("primaryLeaderCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrimaryLeaderCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primaryLeaderName")) {
      Object obj = map.get("primaryLeaderName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrimaryLeaderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("districtCode")) {
      Object obj = map.get("districtCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrictCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizUnitCode")) {
      Object obj = map.get("bizUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevelOneDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevelOneDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPushTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("insertTime")) {
      Object obj = map.get("insertTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInsertTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInsertTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInsertTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInsertTime(null);
      }
    }
    if(map.containsKey("departmentName")) {
      Object obj = map.get("departmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ddId")) {
      Object obj = map.get("ddId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invalidPushStatusYkb")) {
      Object obj = map.get("invalidPushStatusYkb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvalidPushStatusYkb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvalidDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvalidDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvalidDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvalidDate(null);
      }
    }
    if(map.containsKey("ykbParentCode")) {
      Object obj = map.get("ykbParentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYkbParentCode((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("relationCodes")) {
      Object obj = map.get("relationCodes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelationCodes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistrict((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizUnit")) {
      Object obj = map.get("bizUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccStatus")) {
      Object obj = map.get("ccStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extensionTag")) {
      Object obj = map.get("extensionTag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtensionTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kam")) {
      Object obj = map.get("kam");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKam((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOwnerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOwnerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primaryLeaderCode")) {
      Object obj = map.get("primaryLeaderCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrimaryLeaderCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("primaryLeaderName")) {
      Object obj = map.get("primaryLeaderName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrimaryLeaderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("districtCode")) {
      Object obj = map.get("districtCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistrictCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizUnitCode")) {
      Object obj = map.get("bizUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kamCode")) {
      Object obj = map.get("kamCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKamCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevelOneDepartmentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevelOneDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPushTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("insertTime")) {
      Object obj = map.get("insertTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInsertTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInsertTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInsertTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInsertTime(null);
      }
    }
    if(map.containsKey("departmentName")) {
      Object obj = map.get("departmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ddId")) {
      Object obj = map.get("ddId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDdId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invalidPushStatusYkb")) {
      Object obj = map.get("invalidPushStatusYkb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvalidPushStatusYkb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvalidDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvalidDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvalidDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvalidDate(null);
      }
    }
    if(map.containsKey("ykbParentCode")) {
      Object obj = map.get("ykbParentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYkbParentCode((String)obj);
        }
      } else {
      }
    }
  }
}
