package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tenant_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
public enum TenantTypeEnum {

    CENTRE_TENANT("centreTenant", "中心租户"),
    SMALL_TENANT("smallTenant", "小B租户");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TenantTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TenantTypeEnum fromCode(String code){
        switch(code) {
            case "centreTenant":
                return CENTRE_TENANT;
            case "smallTenant":
                return SMALL_TENANT;
            default:
                return null;
        }
    }
}
