package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChargeCodeBudget implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * Chargecode编号
   */
  @TableField("ccCode")
  private String ccCode;

  /**
   * Chargecode描述
   */
  @TableField("ccName")
  private String ccName;

  /**
   * Chargecode类型
   */
  @TableField("ccType")
  private String ccType;

  /**
   * Chargecode负责人工号
   */
  @TableField("ownerCode")
  private String ownerCode;

  /**
   * Chargecode负责人
   */
  @TableField("ownerName")
  private String ownerName;

  /**
   * CFO工号
   */
  @TableField("cfoCode")
  private String cfoCode;

  /**
   * CFO名称
   */
  @TableField("cfoName")
  private String cfoName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 类型code
   */
  @TableField("ccTypeCode")
  private String ccTypeCode;

  /**
   * 一级部门负责人
   */
  @TableField("levelOneDepartmentName")
  private String levelOneDepartmentName;

  /**
   * 一级部门负责人工号
   */
  @TableField("levelOneDepartmentCode")
  private String levelOneDepartmentCode;

  /**
   * 状态
   */
  private String status;

  /**
   * 批次号
   */
  @TableField("requestId")
  private String requestId;

  /**
   * 推送时间
   */
  @TableField("pushTime")
  private String pushTime;

  /**
   * 创建用户Id
   */
  @TableField("ccCreateUserId")
  private Long ccCreateUserId;

  /**
   * 创建用户名称
   */
  @TableField("ccCreateUserName")
  private String ccCreateUserName;

  /**
   * 更新用户Id
   */
  @TableField("ccUpdateUserId")
  private Long ccUpdateUserId;

  /**
   * 更新用户名称
   */
  @TableField("ccUpdateUserName")
  private String ccUpdateUserName;

  /**
   * 审批通过时间
   */
  @TableField("approveDate")
  private String approveDate;

  /**
   * 失效时间
   */
  @TableField("invalidDate")
  private String invalidDate;

  /**
   * 审批通过时间web
   */
  @TableField("approveDateWeb")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approveDateWeb;

  /**
   * 失效时间web
   */
  @TableField("invalidDateWeb")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invalidDateWeb;

  /**
   * Chargecode基础数据失效推送
   */
  @TableField("invalidPushStatusYkb")
  private String invalidPushStatusYkb;


  /**
   * 对一关联关系 关联对象 chargeCodeBudgetPackge
   */
    private Long nodesId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ccCode", ccCode);
      map.put("ccName", ccName);
      map.put("ccType", ccType);
      map.put("ownerCode", ownerCode);
      map.put("ownerName", ownerName);
      map.put("cfoCode", cfoCode);
      map.put("cfoName", cfoName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ccTypeCode", ccTypeCode);
      map.put("levelOneDepartmentName", levelOneDepartmentName);
      map.put("levelOneDepartmentCode", levelOneDepartmentCode);
      map.put("status", status);
      map.put("requestId", requestId);
      map.put("pushTime", pushTime);
      map.put("ccCreateUserId", ccCreateUserId);
      map.put("ccCreateUserName", ccCreateUserName);
      map.put("ccUpdateUserId", ccUpdateUserId);
      map.put("ccUpdateUserName", ccUpdateUserName);
      map.put("approveDate", approveDate);
      map.put("invalidDate", invalidDate);
      map.put("approveDateWeb", BocpGenUtils.toTimestamp(approveDateWeb));
      map.put("invalidDateWeb", BocpGenUtils.toTimestamp(invalidDateWeb));
      map.put("invalidPushStatusYkb", invalidPushStatusYkb);

       map.put("nodes.id", nodesId);
      return map;
  }

  public static ChargeCodeBudget fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ChargeCodeBudget entity = new ChargeCodeBudget();
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cfoCode")) {
      Object obj = map.get("cfoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCfoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cfoName")) {
      Object obj = map.get("cfoName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCfoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevelOneDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLevelOneDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequestId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPushTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApproveDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvalidDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approveDateWeb")) {
      Object obj = map.get("approveDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApproveDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApproveDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApproveDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApproveDateWeb(null);
      }
    }
    if(map.containsKey("invalidDateWeb")) {
      Object obj = map.get("invalidDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvalidDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvalidDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvalidDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvalidDateWeb(null);
      }
    }
    if(map.containsKey("invalidPushStatusYkb")) {
      Object obj = map.get("invalidPushStatusYkb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvalidPushStatusYkb((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("nodes.id")) {
        Object obj = map.get("nodes.id");
      if(obj instanceof Long) {
        entity.setNodesId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setNodesId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ccCode")) {
      Object obj = map.get("ccCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccName")) {
      Object obj = map.get("ccName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccType")) {
      Object obj = map.get("ccType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerCode")) {
      Object obj = map.get("ownerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOwnerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ownerName")) {
      Object obj = map.get("ownerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOwnerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cfoCode")) {
      Object obj = map.get("cfoCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCfoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cfoName")) {
      Object obj = map.get("cfoName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCfoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccTypeCode")) {
      Object obj = map.get("ccTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levelOneDepartmentName")) {
      Object obj = map.get("levelOneDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevelOneDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("levelOneDepartmentCode")) {
      Object obj = map.get("levelOneDepartmentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLevelOneDepartmentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pushTime")) {
      Object obj = map.get("pushTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPushTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccCreateUserId")) {
      Object obj = map.get("ccCreateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCcCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCcCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCcCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ccCreateUserName")) {
      Object obj = map.get("ccCreateUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccUpdateUserId")) {
      Object obj = map.get("ccUpdateUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCcUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCcUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCcUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ccUpdateUserName")) {
      Object obj = map.get("ccUpdateUserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approveDate")) {
      Object obj = map.get("approveDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApproveDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invalidDate")) {
      Object obj = map.get("invalidDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvalidDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("approveDateWeb")) {
      Object obj = map.get("approveDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApproveDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApproveDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApproveDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApproveDateWeb(null);
      }
    }
    if(map.containsKey("invalidDateWeb")) {
      Object obj = map.get("invalidDateWeb");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvalidDateWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvalidDateWeb((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvalidDateWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvalidDateWeb(null);
      }
    }
    if(map.containsKey("invalidPushStatusYkb")) {
      Object obj = map.get("invalidPushStatusYkb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvalidPushStatusYkb((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("nodes.id")) {
        Object obj = map.get("nodes.id");
        if(obj instanceof Long) {
          this.setNodesId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNodesId(Long.parseLong((String)obj));
        }
      }
  }
}
