package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialBasicBillDetail;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialPurchaseBillDetail extends FinancialBasicBillDetail {


  /**
   * 采购申请日期
   */
  @TableField("purchaseApplicationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseApplicationDate;

  /**
   * 消费事由
   */
  private String cause;

  /**
   * 采购需求及说明
   */
  @TableField("purchaseInstructions")
  private String purchaseInstructions;

  /**
   * 项目预算大类编码
   */
  @TableField("projectBudgetTypeCode")
  private String projectBudgetTypeCode;

  /**
   * 项目预算大类名称
   */
  @TableField("projectBudgetTypeName")
  private String projectBudgetTypeName;

  /**
   * 开始日期
   */
  @TableField("purchaseStartDate")
  private String purchaseStartDate;

  /**
   * 结束日期
   */
  @TableField("purchaseEndDate")
  private String purchaseEndDate;

  /**
   * 数量
   */
  private String quantity;

  /**
   * 规格
   */
  private String specification;

  /**
   * 型号
   */
  private String model;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 供应商联系人
   */
  @TableField("supplierLinkman")
  private String supplierLinkman;

  /**
   * 联系方式
   */
  @TableField("contactWay")
  private String contactWay;

  /**
   * 交付时间
   */
  @TableField("deliveryTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryTime;

  /**
   * 交货方式
   */
  @TableField("deliveryWay")
  private String deliveryWay;

  /**
   * 是否有推荐供应商
   */
  @TableField("recommendedSupplier")
  private String recommendedSupplier;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 financialPurchaseBill
   */
    private Long billSubDetailId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("purchaseApplicationDate", BocpGenUtils.toTimestamp(purchaseApplicationDate));
      map.put("cause", cause);
      map.put("purchaseInstructions", purchaseInstructions);
      map.put("projectBudgetTypeCode", projectBudgetTypeCode);
      map.put("projectBudgetTypeName", projectBudgetTypeName);
      map.put("purchaseStartDate", purchaseStartDate);
      map.put("purchaseEndDate", purchaseEndDate);
      map.put("quantity", quantity);
      map.put("specification", specification);
      map.put("model", model);
      map.put("supplierName", supplierName);
      map.put("supplierLinkman", supplierLinkman);
      map.put("contactWay", contactWay);
      map.put("deliveryTime", BocpGenUtils.toTimestamp(deliveryTime));
      map.put("deliveryWay", deliveryWay);
      map.put("recommendedSupplier", recommendedSupplier);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("billSubDetail.id", billSubDetailId);
      return map;
  }

  public static FinancialPurchaseBillDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialPurchaseBillDetail entity = new FinancialPurchaseBillDetail();
    entity.setParentByOQSMap(map);
    if(map.containsKey("purchaseApplicationDate")) {
      Object obj = map.get("purchaseApplicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPurchaseApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseApplicationDate(null);
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseInstructions")) {
      Object obj = map.get("purchaseInstructions");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseInstructions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectBudgetTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectBudgetTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStartDate")) {
      Object obj = map.get("purchaseStartDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStartDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseEndDate")) {
      Object obj = map.get("purchaseEndDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseEndDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specification")) {
      Object obj = map.get("specification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierLinkman")) {
      Object obj = map.get("supplierLinkman");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierLinkman((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contactWay")) {
      Object obj = map.get("contactWay");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryTime")) {
      Object obj = map.get("deliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryTime(null);
      }
    }
    if(map.containsKey("deliveryWay")) {
      Object obj = map.get("deliveryWay");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recommendedSupplier")) {
      Object obj = map.get("recommendedSupplier");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecommendedSupplier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billSubDetail.id")) {
        Object obj = map.get("billSubDetail.id");
      if(obj instanceof Long) {
        entity.setBillSubDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBillSubDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("purchaseApplicationDate")) {
      Object obj = map.get("purchaseApplicationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaseApplicationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPurchaseApplicationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseApplicationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPurchaseApplicationDate(null);
      }
    }
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCause((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseInstructions")) {
      Object obj = map.get("purchaseInstructions");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseInstructions((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectBudgetTypeCode")) {
      Object obj = map.get("projectBudgetTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectBudgetTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("projectBudgetTypeName")) {
      Object obj = map.get("projectBudgetTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectBudgetTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStartDate")) {
      Object obj = map.get("purchaseStartDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStartDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseEndDate")) {
      Object obj = map.get("purchaseEndDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseEndDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specification")) {
      Object obj = map.get("specification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String) {
          this.setModel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierLinkman")) {
      Object obj = map.get("supplierLinkman");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierLinkman((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contactWay")) {
      Object obj = map.get("contactWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContactWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryTime")) {
      Object obj = map.get("deliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryTime(null);
      }
    }
    if(map.containsKey("deliveryWay")) {
      Object obj = map.get("deliveryWay");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("recommendedSupplier")) {
      Object obj = map.get("recommendedSupplier");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecommendedSupplier((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("billSubDetail.id")) {
        Object obj = map.get("billSubDetail.id");
        if(obj instanceof Long) {
          this.setBillSubDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillSubDetailId(Long.parseLong((String)obj));
        }
      }
  }
}
