package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yes_no_enum
 * </p>
 *
 * @author ultraman
 * @since 2023-12-18
 */
public enum YesNoEnum {

    YES("yes", "是"),
    NO("no", "否");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YesNoEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesNoEnum fromCode(String code){
        switch(code) {
            case "yes":
                return YES;
            case "no":
                return NO;
            default:
                return null;
        }
    }
}
