package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.financialsettlement.entity.FinancialApplyBasicBill;

/**
 * <p>
 * 退款申请单
 * </p>
 *
 * @author ultraman
 * @since 2023-12-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FinancialRefundBill extends FinancialApplyBasicBill {


  /**
   * 退款事由
   */
  private String cause;

  /**
   * 需退款金额
   */
  @TableField("refundAmount")
  private String refundAmount;

  /**
   * 客户名称
   */
  @TableField("customerName")
  private String customerName;

  /**
   * 付款公司主体编码
   */
  @TableField("claimCompanyCode")
  private String claimCompanyCode;

  /**
   * 付款公司主体名称
   */
  @TableField("claimCompanyName")
  private String claimCompanyName;

  /**
   * 退款项目编码
   */
  @TableField("refundProjectCode")
  private String refundProjectCode;

  /**
   * 退款项目名称
   */
  @TableField("refundProjectName")
  private String refundProjectName;

  /**
   * 退款理由编码
   */
  @TableField("refundCauseCode")
  private String refundCauseCode;

  /**
   * 退款理由名称
   */
  @TableField("refundCauseName")
  private String refundCauseName;

  /**
   * 退回发票选择
   */
  @TableField("returnInvoice")
  private String returnInvoice;

  /**
   * 理由补充说明
   */
  @TableField("additionalRemarks")
  private String additionalRemarks;

  /**
   * 收款银行
   */
  @TableField("dueBank")
  private String dueBank;

  /**
   * 收款账号
   */
  @TableField("accountNumber")
  private String accountNumber;

  /**
   * 收款人
   */
  private String payee;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("cause", cause);
      map.put("refundAmount", refundAmount);
      map.put("customerName", customerName);
      map.put("claimCompanyCode", claimCompanyCode);
      map.put("claimCompanyName", claimCompanyName);
      map.put("refundProjectCode", refundProjectCode);
      map.put("refundProjectName", refundProjectName);
      map.put("refundCauseCode", refundCauseCode);
      map.put("refundCauseName", refundCauseName);
      map.put("returnInvoice", returnInvoice);
      map.put("additionalRemarks", additionalRemarks);
      map.put("dueBank", dueBank);
      map.put("accountNumber", accountNumber);
      map.put("payee", payee);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static FinancialRefundBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    FinancialRefundBill entity = new FinancialRefundBill();
    entity.setParentByOQSMap(map);
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCause((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundAmount")) {
      Object obj = map.get("refundAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClaimCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClaimCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundProjectCode")) {
      Object obj = map.get("refundProjectCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundProjectName")) {
      Object obj = map.get("refundProjectName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundCauseCode")) {
      Object obj = map.get("refundCauseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundCauseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundCauseName")) {
      Object obj = map.get("refundCauseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundCauseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnInvoice")) {
      Object obj = map.get("returnInvoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("additionalRemarks")) {
      Object obj = map.get("additionalRemarks");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdditionalRemarks((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDueBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("cause")) {
      Object obj = map.get("cause");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCause((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundAmount")) {
      Object obj = map.get("refundAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerName")) {
      Object obj = map.get("customerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimCompanyCode")) {
      Object obj = map.get("claimCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClaimCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("claimCompanyName")) {
      Object obj = map.get("claimCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClaimCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundProjectCode")) {
      Object obj = map.get("refundProjectCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundProjectCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundProjectName")) {
      Object obj = map.get("refundProjectName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundProjectName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundCauseCode")) {
      Object obj = map.get("refundCauseCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundCauseCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundCauseName")) {
      Object obj = map.get("refundCauseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundCauseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnInvoice")) {
      Object obj = map.get("returnInvoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnInvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("additionalRemarks")) {
      Object obj = map.get("additionalRemarks");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAdditionalRemarks((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dueBank")) {
      Object obj = map.get("dueBank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDueBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountNumber")) {
      Object obj = map.get("accountNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
