package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * adjust_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-03-04
 */
public enum AdjustStatusEnum {

    _0("0", "正常"),
    _1("1", "调整");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AdjustStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AdjustStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
