package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * contract_appoint
 * </p>
 *
 * @author ultraman
 * @since 2024-03-04
 */
public enum ContractAppoint {

    _0("0", "有期限，可自动延续"),
    _1("1", "有期限，无自动延续"),
    _2("2", "无期限，无自动延续"),
    _3("3", "未约定");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractAppoint(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractAppoint fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
