package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pay_status
 * </p>
 *
 * @author ultraman
 * @since 2024-03-04
 */
public enum PayStatus {

    CANCEL("CANCEL", "已作废"),
    UN_PAID("UN_PAID", "未支付"),
    PAID("PAID", "已支付"),
    UN_CANCEL("UN_CANCEL", "未作废"),
    PART_PAY("PART_PAY", "部分支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayStatus fromCode(String code){
        switch(code) {
            case "CANCEL":
                return CANCEL;
            case "UN_PAID":
                return UN_PAID;
            case "PAID":
                return PAID;
            case "UN_CANCEL":
                return UN_CANCEL;
            case "PART_PAY":
                return PART_PAY;
            default:
                return null;
        }
    }
}
