package com.xforceplus.financialsettlement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * statistics_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-04
 */
public enum StatisticsType {

    CHARGECODE_TYPE("ChargecodeType", "Chargecode类型"),
    CHARGECODE_DEPARTMENT("ChargecodeDepartment", "Chargecode所属部门");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StatisticsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatisticsType fromCode(String code){
        switch(code) {
            case "ChargecodeType":
                return CHARGECODE_TYPE;
            case "ChargecodeDepartment":
                return CHARGECODE_DEPARTMENT;
            default:
                return null;
        }
    }
}
