package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MemberInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 员工姓名
   */
  private String memberName;

  /**
   * 员工工号
   */
  private String memberCode;

  /**
   * 合同签署公司
   */
  private String belongsCompany;

  /**
   * 所属公司税号
   */
  private String belongsCompanyTaxNo;

  /**
   * 公司邮箱
   */
  private String companyEmailAddress;

  /**
   * 手机号码
   */
  private String memberPhoneNo;

  /**
   * 状态
   */
  private String memberStatus;

  /**
   * 所属部门
   */
  private String belongsDepartment;

  /**
   * 直属领导工号
   */
  private String primaryLeaderCode;

  /**
   * 直属领导
   */
  private String primaryLeaderName;

  /**
   * 所属一级部门
   */
  private String levelOneDepartmentName;

  /**
   * 易快报同步id
   */
  private String ykbSyncId;

  /**
   * 一级部门code
   */
  private String levelOneDepartmentCode;

  /**
   * 一级部门负责人
   */
  private String levelOneDepartmentOwnerName;

  /**
   * 一级部门负责人工号
   */
  private String levelOneDepartmentOwnerCode;

  /**
   * 职级
   */
  private String memberLevel;

  /**
   * 所属部门code
   */
  private String belongsDepartmentCode;

  /**
   * 是否外包
   */
  private String isOuter;

  /**
   * 入职时间
   */
  private String inductionTime;

  /**
   * 离职时间
   */
  private String leaveTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 同步时间
   */
  private String syncTime;

  /**
   * 当前员工userId
   */
  private Long userId;

  /**
   * 所属公司序号
   */
  private String belongsCompanySeira;

  /**
   * 直属领导人userId
   */
  private String primaryLeaderUserId;

  /**
   * 一级部门负责人userId
   */
  private String levelOneDepartmentOwnerUserId;

  /**
   * 一级部门id
   */
  private String levelOneDepartmentId;

  /**
   * 所属部门id
   */
  private String belongsDepartmentId;

  /**
   * 入职时间web
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime inductionTimeWeb;

  /**
   * 离职时间web
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime leaveTimeWeb;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("member_name", memberName);
      map.put("member_code", memberCode);
      map.put("belongs_company", belongsCompany);
      map.put("belongs_company_tax_no", belongsCompanyTaxNo);
      map.put("company_email_address", companyEmailAddress);
      map.put("member_phone_no", memberPhoneNo);
      map.put("member_status", memberStatus);
      map.put("belongs_department", belongsDepartment);
      map.put("primary_leader_code", primaryLeaderCode);
      map.put("primary_leader_name", primaryLeaderName);
      map.put("level_one_department_name", levelOneDepartmentName);
      map.put("ykb_sync_id", ykbSyncId);
      map.put("level_one_department_code", levelOneDepartmentCode);
      map.put("level_one_department_owner_name", levelOneDepartmentOwnerName);
      map.put("level_one_department_owner_code", levelOneDepartmentOwnerCode);
      map.put("member_level", memberLevel);
      map.put("belongs_department_code", belongsDepartmentCode);
      map.put("is_outer", isOuter);
      map.put("induction_time", inductionTime);
      map.put("leave_time", leaveTime);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sync_time", syncTime);
      map.put("user_id", userId);
      map.put("belongs_company_seira", belongsCompanySeira);
      map.put("primary_leader_user_id", primaryLeaderUserId);
      map.put("level_one_department_owner_user_id", levelOneDepartmentOwnerUserId);
      map.put("level_one_department_id", levelOneDepartmentId);
      map.put("belongs_department_id", belongsDepartmentId);
      map.put("induction_time_web", BocpGenUtils.toTimestamp(inductionTimeWeb));
      map.put("leave_time_web", BocpGenUtils.toTimestamp(leaveTimeWeb));
      return map;
  }

  public static MemberInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MemberInfo entity = new MemberInfo();
    if(map.containsKey("member_name")) {
      Object obj = map.get("member_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("member_code")) {
      Object obj = map.get("member_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongs_company")) {
      Object obj = map.get("belongs_company");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongs_company_tax_no")) {
      Object obj = map.get("belongs_company_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_email_address")) {
      Object obj = map.get("company_email_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyEmailAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("member_phone_no")) {
      Object obj = map.get("member_phone_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberPhoneNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("member_status")) {
      Object obj = map.get("member_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongs_department")) {
      Object obj = map.get("belongs_department");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsDepartment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primary_leader_code")) {
      Object obj = map.get("primary_leader_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryLeaderCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primary_leader_name")) {
      Object obj = map.get("primary_leader_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryLeaderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_name")) {
      Object obj = map.get("level_one_department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ykb_sync_id")) {
      Object obj = map.get("ykb_sync_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYkbSyncId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_code")) {
      Object obj = map.get("level_one_department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_owner_name")) {
      Object obj = map.get("level_one_department_owner_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentOwnerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_owner_code")) {
      Object obj = map.get("level_one_department_owner_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentOwnerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("member_level")) {
      Object obj = map.get("member_level");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemberLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongs_department_code")) {
      Object obj = map.get("belongs_department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_outer")) {
      Object obj = map.get("is_outer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsOuter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("induction_time")) {
      Object obj = map.get("induction_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInductionTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leave_time")) {
      Object obj = map.get("leave_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLeaveTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sync_time")) {
      Object obj = map.get("sync_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_id")) {
      Object obj = map.get("user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("belongs_company_seira")) {
      Object obj = map.get("belongs_company_seira");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsCompanySeira((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("primary_leader_user_id")) {
      Object obj = map.get("primary_leader_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrimaryLeaderUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_owner_user_id")) {
      Object obj = map.get("level_one_department_owner_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentOwnerUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level_one_department_id")) {
      Object obj = map.get("level_one_department_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevelOneDepartmentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongs_department_id")) {
      Object obj = map.get("belongs_department_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongsDepartmentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("induction_time_web")) {
      Object obj = map.get("induction_time_web");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInductionTimeWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInductionTimeWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInductionTimeWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInductionTimeWeb(null);
      }
    }
    if(map.containsKey("leave_time_web")) {
      Object obj = map.get("leave_time_web");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLeaveTimeWeb(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLeaveTimeWeb((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLeaveTimeWeb(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLeaveTimeWeb(null);
      }
    }
    return entity;
  }
}
